/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;

public class TextItem
extends Inlist<TextItem> {
    private static final int MAX_POOL = 250;
    public static final SyncPool<TextItem> pool = new SyncPool<TextItem>(250){

        @Override
        protected TextItem createItem() {
            return new TextItem();
        }

        @Override
        protected boolean clearItem(TextItem ti) {
            ti.string = null;
            ti.text = null;
            return true;
        }
    };
    public float x;
    public float y;
    public String string;
    public TextStyle text;
    public float width;
    public float x1;
    public float y1;
    public float x2;
    public float y2;
    public short length;
    public byte edges;

    public static TextItem copy(TextItem orig) {
        TextItem ti = pool.get();
        ti.x = orig.x;
        ti.y = orig.y;
        ti.x1 = orig.x1;
        ti.y1 = orig.y1;
        ti.x2 = orig.x2;
        ti.y2 = orig.y2;
        return ti;
    }

    public TextItem set(float x, float y, String string, TextStyle text) {
        this.x = x;
        this.y = y;
        this.string = string;
        this.text = text;
        this.x1 = 0.0f;
        this.y1 = 0.0f;
        this.x2 = 1.0f;
        this.y2 = 0.0f;
        this.width = text.paint.measureText(string);
        return this;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.string;
    }
}

