/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.AtlasRenderTheme;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlThemeBuilder;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.utils.TextureAtlasUtils;

public class XmlAtlasThemeBuilder
extends XmlThemeBuilder {
    private final Map<Object, TextureRegion> regionMap;
    private final List<TextureAtlas> atlasList;
    private final Map<Object, Bitmap> bitmapMap = new HashMap<Object, Bitmap>();

    public static IRenderTheme read(ThemeFile theme) throws IRenderTheme.ThemeException {
        return XmlAtlasThemeBuilder.read(theme, null);
    }

    public static IRenderTheme read(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        HashMap<Object, TextureRegion> outputMap = new HashMap<Object, TextureRegion>();
        ArrayList<TextureAtlas> atlasList = new ArrayList<TextureAtlas>();
        XmlAtlasThemeBuilder renderThemeHandler = new XmlAtlasThemeBuilder(theme, themeCallback, outputMap, atlasList);
        try {
            new XMLReaderAdapter().parse(renderThemeHandler, theme.getRenderThemeAsStream());
        }
        catch (Exception e) {
            throw new IRenderTheme.ThemeException(e.getMessage());
        }
        TextureAtlasUtils.createTextureRegions(renderThemeHandler.bitmapMap, outputMap, atlasList, true, CanvasAdapter.platform == Platform.IOS);
        return XmlAtlasThemeBuilder.replaceThemeSymbols(renderThemeHandler.mRenderTheme, outputMap);
    }

    private static IRenderTheme replaceThemeSymbols(RenderTheme renderTheme, Map<Object, TextureRegion> regionMap) {
        SymbolStyle.SymbolBuilder<?> symbolBuilder = SymbolStyle.builder();
        for (Rule rule : renderTheme.getRules()) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(rule, regionMap, symbolBuilder);
        }
        return renderTheme;
    }

    private static void replaceRuleSymbols(Rule rule, Map<Object, TextureRegion> regionMap, SymbolStyle.SymbolBuilder<?> symbolBuilder) {
        for (RenderStyle style : rule.styles) {
            int hash;
            TextureRegion region;
            if (!(style instanceof SymbolStyle) || (region = regionMap.get(hash = ((SymbolStyle)style).hash)) == null) continue;
            Object b = symbolBuilder.reset();
            rule.styles[i] = ((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)b).texture(region)).build();
        }
        for (Rule subRule : rule.subRules) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(subRule, regionMap, symbolBuilder);
        }
    }

    public XmlAtlasThemeBuilder(ThemeFile theme, Map<Object, TextureRegion> regionMap, List<TextureAtlas> atlasList) {
        this(theme, null, regionMap, atlasList);
    }

    public XmlAtlasThemeBuilder(ThemeFile theme, ThemeCallback themeCallback, Map<Object, TextureRegion> regionMap, List<TextureAtlas> atlasList) {
        super(theme, themeCallback);
        this.regionMap = regionMap;
        this.atlasList = atlasList;
    }

    @Override
    RenderTheme createTheme(Rule[] rules) {
        return new AtlasRenderTheme(this.mMapBackground, this.mTextScale, rules, this.mLevels, this.regionMap, this.atlasList);
    }

    @Override
    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b, String src, Bitmap bitmap) {
        String absoluteName = CanvasAdapter.getAbsoluteFile(this.mTheme.getRelativePathPrefix(), src).getAbsolutePath();
        int hash = (absoluteName + b.symbolWidth + b.symbolHeight + b.symbolPercent).hashCode();
        this.bitmapMap.put(hash, bitmap);
        return ((SymbolStyle.SymbolBuilder)b.hash(hash)).build();
    }
}

