/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;

public abstract class RenderStyle<T extends RenderStyle<T>> {
    public String cat = null;
    RenderStyle mCurrent = this;
    RenderStyle mNext;
    boolean update;

    public T setCat(String cat) {
        this.cat = cat;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public void set(RenderStyle next) {
        this.update = true;
        this.mNext = next;
    }

    public void unsetOverride() {
        this.update = true;
        this.mNext = null;
    }

    public void dispose() {
    }

    public void renderNode(Callback renderCallback) {
    }

    public void renderWay(Callback renderCallback) {
    }

    public void scaleTextSize(float scaleFactor) {
    }

    public void update() {
        if (this.update) {
            this.update = false;
            this.mCurrent = this.mNext;
        }
    }

    public abstract RenderStyle current();

    public static interface Callback {
        public void renderArea(AreaStyle var1, int var2);

        public void renderExtrusion(ExtrusionStyle var1, int var2);

        public void renderCircle(CircleStyle var1, int var2);

        public void renderSymbol(SymbolStyle var1);

        public void renderWay(LineStyle var1, int var2);

        public void renderText(TextStyle var1);
    }

    public static abstract class StyleBuilder<T extends StyleBuilder<T>> {
        public String cat;
        public String style;
        public int level;
        public int fillColor;
        public int strokeColor;
        public float strokeWidth;
        public ThemeCallback themeCallback;

        public T cat(String cat) {
            this.cat = cat;
            return this.self();
        }

        public T style(String style) {
            this.style = style;
            return this.self();
        }

        public T level(int level) {
            this.level = level;
            return this.self();
        }

        public T outline(int color, float width) {
            this.strokeColor = color;
            this.strokeWidth = width;
            return this.self();
        }

        public T strokeColor(int color) {
            this.strokeColor = color;
            return this.self();
        }

        public T strokeColor(String color) {
            this.strokeColor = Color.parseColor(color);
            return this.self();
        }

        public T strokeWidth(float width) {
            this.strokeWidth = width;
            return this.self();
        }

        public T color(int color) {
            this.fillColor = color;
            return this.self();
        }

        public T color(String color) {
            this.fillColor = Color.parseColor(color);
            return this.self();
        }

        public T themeCallback(ThemeCallback themeCallback) {
            this.themeCallback = themeCallback;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public abstract RenderStyle build();
    }
}

