/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.oscim.core.Tile;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.LwHttp;

public abstract class UrlTileSource
extends TileSource {
    public static final TileUrlFormatter URL_FORMATTER = new DefaultTileUrlFormatter();
    private final URL mUrl;
    private final String[] mTilePath;
    private HttpEngine.Factory mHttpFactory;
    private Map<String, String> mRequestHeaders = Collections.emptyMap();
    private TileUrlFormatter mTileUrlFormatter = URL_FORMATTER;
    private String mApiKey;

    protected UrlTileSource(Builder<?> builder) {
        super(builder);
        this.mApiKey = ((Builder)builder).apiKey;
        this.mUrl = this.makeUrl(builder.url);
        this.mTilePath = builder.tilePath.split("\\{|\\}");
        this.mHttpFactory = ((Builder)builder).engineFactory;
    }

    protected UrlTileSource(String urlString, String tilePath) {
        this(urlString, tilePath, 0, 17);
    }

    protected UrlTileSource(String urlString, String tilePath, int zoomMin, int zoomMax) {
        super(zoomMin, zoomMax);
        this.mUrl = this.makeUrl(urlString);
        this.mTilePath = this.makeTilePath(tilePath);
    }

    private String[] makeTilePath(String tilePath) {
        if (tilePath == null) {
            throw new IllegalArgumentException("tilePath cannot be null.");
        }
        return tilePath.split("\\{|\\}");
    }

    private URL makeUrl(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return url;
    }

    @Override
    public TileSource.OpenResult open() {
        return TileSource.OpenResult.SUCCESS;
    }

    @Override
    public void close() {
    }

    public void setApiKey(String apiKey) {
        this.mApiKey = apiKey;
    }

    public URL getUrl() {
        return this.mUrl;
    }

    public String getTileUrl(Tile tile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mUrl).append(this.mTileUrlFormatter.formatTilePath(this, tile));
        if (this.mApiKey != null) {
            sb.append("?api_key=").append(this.mApiKey);
        }
        return sb.toString();
    }

    public void setHttpEngine(HttpEngine.Factory httpFactory) {
        this.mHttpFactory = httpFactory;
    }

    public void setHttpRequestHeaders(Map<String, String> options) {
        this.mRequestHeaders = options;
    }

    public Map<String, String> getRequestHeader() {
        return this.mRequestHeaders;
    }

    public String[] getTilePath() {
        return this.mTilePath;
    }

    public void setUrlFormatter(TileUrlFormatter formatter) {
        this.mTileUrlFormatter = formatter;
    }

    public TileUrlFormatter getUrlFormatter() {
        return this.mTileUrlFormatter;
    }

    public HttpEngine getHttpEngine() {
        if (this.mHttpFactory == null) {
            this.mHttpFactory = new LwHttp.LwHttpFactory();
        }
        return this.mHttpFactory.create(this);
    }

    public int tileXToUrlX(int tileX) {
        return tileX;
    }

    public int tileYToUrlY(int tileY) {
        return tileY;
    }

    public int tileZToUrlZ(int tileZ) {
        return tileZ;
    }

    private static class DefaultTileUrlFormatter
    implements TileUrlFormatter {
        private DefaultTileUrlFormatter() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String formatTilePath(UrlTileSource tileSource, Tile tile) {
            sb = new StringBuilder();
            block5: for (String b : tileSource.getTilePath()) {
                if (b.length() != 1) ** GOTO lbl-1000
                switch (b.charAt(0)) {
                    case 'X': {
                        sb.append(tileSource.tileXToUrlX(tile.tileX));
                        continue block5;
                    }
                    case 'Y': {
                        sb.append(tileSource.tileYToUrlY(tile.tileY));
                        continue block5;
                    }
                    case 'Z': {
                        sb.append(tileSource.tileZToUrlZ(tile.zoomLevel));
                        continue block5;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        sb.append(b);
                    }
                }
            }
            return sb.toString();
        }
    }

    public static interface TileUrlFormatter {
        public String formatTilePath(UrlTileSource var1, Tile var2);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends TileSource.Builder<T> {
        protected String tilePath;
        protected String url;
        private HttpEngine.Factory engineFactory;
        private String apiKey;

        protected Builder() {
        }

        protected Builder(String url, String tilePath, int zoomMin, int zoomMax) {
            this.url = url;
            this.tilePath = tilePath;
            this.zoomMin = zoomMin;
            this.zoomMax = zoomMax;
        }

        public T apiKey(String apiKey) {
            this.apiKey = apiKey;
            return (T)((Builder)this.self());
        }

        public T tilePath(String tilePath) {
            this.tilePath = tilePath;
            return (T)((Builder)this.self());
        }

        public T url(String url) {
            this.url = url;
            return (T)((Builder)this.self());
        }

        public T httpFactory(HttpEngine.Factory factory) {
            this.engineFactory = factory;
            return (T)((Builder)this.self());
        }
    }
}

