/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.utils.FastMath;

public class Easing {
    public static float ease(long start, long current, float duration, Type easingType) {
        long millisElapsed = current - start;
        if ((float)millisElapsed > duration) {
            return 1.0f;
        }
        float x = (float)millisElapsed / duration;
        float t = millisElapsed;
        float b = 0.0f;
        float c = 1.0f;
        float d = duration;
        float adv = 0.0f;
        switch (easingType) {
            case LINEAR: {
                adv = Easing.linear(x, t, b, c, d);
                break;
            }
            case SINE_INOUT: {
                adv = Easing.sineInout(x, t, b, c, d);
                break;
            }
            case EXPO_OUT: {
                adv = Easing.expoOut(x, t, b, c, d);
                break;
            }
            case QUAD_INOUT: {
                adv = Easing.quadInout(x, t, b, c, d);
                break;
            }
            case CUBIC_INOUT: {
                adv = Easing.cubicInout(x, t, b, c, d);
                break;
            }
            case QUART_INOUT: {
                adv = Easing.quartInout(x, t, b, c, d);
                break;
            }
            case QUINT_INOUT: {
                adv = Easing.quintInout(x, t, b, c, d);
            }
        }
        adv = FastMath.clamp(adv, 0.0f, 1.0f);
        return adv;
    }

    private static float linear(float x, float t, float b, float c, float d) {
        return c * x + b;
    }

    private static float sineInout(float x, float t, float b, float c, float d) {
        return -c / 2.0f * (float)(Math.cos(Math.PI * (double)t / (double)d) - 1.0) + b;
    }

    private static float expoOut(float x, float t, float b, float c, float d) {
        return t == d ? b + c : c * (float)(-Math.pow(2.0, -10.0f * x) + 1.0) + b;
    }

    private static float quadInout(float x, float t, float b, float c, float d) {
        float f;
        t /= d / 2.0f;
        if (f < 1.0f) {
            return c / 2.0f * t * t + b;
        }
        return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
    }

    private static float cubicInout(float x, float t, float b, float c, float d) {
        float f;
        t /= d / 2.0f;
        if (f < 1.0f) {
            return c / 2.0f * t * t * t + b;
        }
        return c / 2.0f * ((t -= 2.0f) * t * t + 2.0f) + b;
    }

    private static float quartInout(float x, float t, float b, float c, float d) {
        float f;
        t /= d / 2.0f;
        if (f < 1.0f) {
            return c / 2.0f * t * t * t * t + b;
        }
        return -c / 2.0f * ((t -= 2.0f) * t * t * t - 2.0f) + b;
    }

    private static float quintInout(float x, float t, float b, float c, float d) {
        float f;
        t /= d / 2.0f;
        if (f < 1.0f) {
            return c / 2.0f * t * t * t * t * t + b;
        }
        return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
    }

    public static enum Type {
        LINEAR,
        SINE_INOUT,
        EXPO_OUT,
        QUAD_INOUT,
        CUBIC_INOUT,
        QUART_INOUT,
        QUINT_INOUT;

    }
}

