/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PausableThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(PausableThread.class);
    private static final boolean dbg = false;
    private boolean mPausing = true;
    private boolean mRunning = true;
    private boolean mShouldPause = false;
    private boolean mShouldStop = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitPausing() {
        PausableThread pausableThread = this;
        synchronized (pausableThread) {
            while (!this.isPausing()) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }

    public synchronized void finish() {
        if (!this.mRunning) {
            return;
        }
        log.debug("Finish {}", (Object)this.getThreadName());
        this.mShouldStop = true;
        this.interrupt();
    }

    public final synchronized boolean isPausing() {
        return this.mPausing;
    }

    public final synchronized void pause() {
        if (!this.mShouldPause) {
            this.mShouldPause = true;
            this.interrupt();
        }
    }

    public final synchronized void proceed() {
        if (this.mShouldPause) {
            this.mShouldPause = false;
            this.notify();
        }
    }

    public final synchronized boolean isCanceled() {
        return this.mShouldPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.mRunning = true;
        this.setName(this.getThreadName());
        this.setPriority(this.getThreadPriority());
        block7: while (!this.mShouldStop) {
            PausableThread pausableThread = this;
            synchronized (pausableThread) {
                if (this.mShouldStop) {
                    break;
                }
                while (this.mShouldPause || !this.hasWork()) {
                    try {
                        if (this.mShouldPause) {
                            this.mPausing = true;
                        }
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (!this.mShouldStop) continue;
                        break block7;
                    }
                }
                if (this.mPausing) {
                    this.mPausing = false;
                    this.afterPause();
                }
            }
            try {
                this.doWork();
            }
            catch (InterruptedException interruptedException) {}
        }
        log.debug("Done {}", (Object)this.getThreadName());
        this.mPausing = true;
        this.mRunning = false;
        this.afterRun();
    }

    protected void afterPause() {
    }

    protected void afterRun() {
    }

    protected abstract void doWork() throws InterruptedException;

    protected abstract String getThreadName();

    protected int getThreadPriority() {
        return 5;
    }

    protected abstract boolean hasWork();
}

