/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.Arrays;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.FastMath;
import org.oscim.utils.TessJNI;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tessellator {
    static final Logger log = LoggerFactory.getLogger(Tessellator.class);

    public static int tessellate(float[] points, int ppos, int numPoints, int[] index, int ipos, int numRings, int vertexOffset, VertexData outTris) {
        int size;
        int buckets = FastMath.log2(MathUtils.nextPowerOfTwo(numPoints));
        TessJNI tess = new TessJNI(buckets -= 2);
        tess.addContour2D(index, points, ipos, numRings);
        if (!tess.tesselate()) {
            return 0;
        }
        int nverts = tess.getVertexCount() * 2;
        int nelems = tess.getElementCount() * 3;
        if (numPoints != nverts) {
            log.debug("tess ----- skip poly: " + nverts + " " + numPoints);
            tess.dispose();
            return 0;
        }
        int sumIndices = 0;
        VertexData.Chunk vd = outTris.obtainChunk();
        for (int offset = 0; offset < nelems; offset += size) {
            int i;
            size = nelems - offset;
            if (360 == vd.used) {
                vd = outTris.obtainChunk();
            }
            if (size > 360 - vd.used) {
                size = 360 - vd.used;
            }
            tess.getElementsWithInputVertexIds(vd.vertices, vd.used, offset, size);
            int start = vd.used;
            int end = start + size;
            short[] indices = vd.vertices;
            int i2 = start;
            while (i2 < end) {
                if (indices[i2] < 0) {
                    log.debug(">>>> eeek {} {} {}", new Object[]{start, end, Arrays.toString(Arrays.copyOfRange(indices, start, end))});
                    break;
                }
                int n = i2++;
                indices[n] = (short)(indices[n] * 2);
            }
            short shift = 0;
            int m = numRings - 1;
            for (i = 0; i < m; ++i) {
                shift += index[ipos + i];
                if ((index[ipos + i] >> 1 & 1) == 0) continue;
                for (int j = start; j < end; ++j) {
                    if (indices[j] < shift) continue;
                    int n = j;
                    indices[n] = (short)(indices[n] + 2);
                }
                shift += 2;
            }
            i = start;
            while (i < end) {
                int n = i++;
                indices[n] = (short)(indices[n] + vertexOffset);
            }
            sumIndices += size;
            vd.used += size;
            outTris.releaseChunk();
        }
        tess.dispose();
        return sumIndices;
    }
}

