/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

public class OBB2D {
    float originX;
    float originY;
    public final float[] vec = new float[12];
    private static final int CORNER_X = 0;
    private static final int CORNER_Y = 1;
    private static final int CORNER_0 = 0;
    private static final int CORNER_1 = 2;
    private static final int CORNER_3 = 6;
    private static final int AXIS_X = 8;
    private static final int AXIS_Y = 9;
    private static final int AXIS_1 = 8;
    private static final int AXIS_2 = 10;

    private boolean overlaps1Way(OBB2D other) {
        for (int a = 0; a <= 2; a += 2) {
            float t;
            float ax = this.vec[8 + a];
            float ay = this.vec[9 + a];
            float tMin = t = ax * other.vec[0] + ay * other.vec[1];
            float tMax = t;
            for (int c = 2; c < 8; c += 2) {
                t = ax * other.vec[c] + ay * other.vec[c + 1];
                if (t < tMin) {
                    tMin = t;
                    continue;
                }
                if (!(t > tMax)) continue;
                tMax = t;
            }
            if (!(a == 0 ? tMin > 1.0f + this.originX || tMax < this.originX : tMin > 1.0f + this.originY || tMax < this.originY)) continue;
            return false;
        }
        return true;
    }

    private void computeAxes() {
        Vec2.sub(this.vec, 8, 2, 0);
        Vec2.sub(this.vec, 10, 6, 0);
        Vec2.normalizeSquared(this.vec, 8);
        this.originX = Vec2.dot(this.vec, 0, 8);
        Vec2.normalizeSquared(this.vec, 10);
        this.originY = Vec2.dot(this.vec, 0, 10);
    }

    public OBB2D() {
    }

    public OBB2D(float cx, float cy, float width, float height, double acos, double asin) {
        float vx = (float)acos * width / 2.0f;
        float vy = (float)asin * width / 2.0f;
        float ux = (float)(-asin) * height / 2.0f;
        float uy = (float)acos * height / 2.0f;
        this.vec[0] = cx + (vx - ux);
        this.vec[1] = cy + (vy - uy);
        this.vec[2] = cx + (-vx - ux);
        this.vec[3] = cy + (-vy - uy);
        this.vec[4] = cx + (-vx + ux);
        this.vec[5] = cy + (-vy + uy);
        this.vec[6] = cx + (vx + ux);
        this.vec[7] = cy + (vy + uy);
        this.computeAxes();
    }

    public void setNormalized(float cx, float cy, float vx, float vy, float width, float height, float dy) {
        float ux = -vy;
        float uy = vx;
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (dy != 0.0f) {
            cx += vx * dy + vy * dy;
            cy += -vy * dy + vx * dy;
        }
        this.vec[0] = cx - ((vx *= hw) - (ux *= hh));
        this.vec[1] = cy - ((vy *= hw) - (uy *= hh));
        this.vec[2] = cx + (vx - ux);
        this.vec[3] = cy + (vy - uy);
        this.vec[4] = cx + (vx + ux);
        this.vec[5] = cy + (vy + uy);
        this.vec[6] = cx - (vx + ux);
        this.vec[7] = cy - (vy + uy);
        this.computeAxes();
    }

    public void set(float cx, float cy, float dx, float dy, float width, float height) {
        float vx = cx - dx;
        float vy = cy - dy;
        float a = (float)Math.sqrt(vx * vx + vy * vy);
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        float ux = (vy /= a) * hh;
        float uy = -(vx /= a) * hh;
        this.vec[0] = cx - (vx *= hw) - ux;
        this.vec[1] = cy - (vy *= hw) - uy;
        this.vec[2] = cx + vx - ux;
        this.vec[3] = cy + vy - uy;
        this.vec[4] = cx + vx + ux;
        this.vec[5] = cy + vy + uy;
        this.vec[6] = cx - vx + ux;
        this.vec[7] = cy - vy + uy;
        this.computeAxes();
    }

    public OBB2D(float cx, float cy, float dx, float dy, float width, float height) {
        float vx = cx - dx;
        float vy = cy - dy;
        float a = (float)Math.sqrt(vx * vx + vy * vy);
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        float ux = (vy /= a) * hh;
        float uy = -(vx /= a) * hh;
        this.vec[0] = cx - (vx *= hw) - ux;
        this.vec[1] = cy - (vy *= hw) - uy;
        this.vec[2] = cx + vx - ux;
        this.vec[3] = cy + vy - uy;
        this.vec[4] = cx + vx + ux;
        this.vec[5] = cy + vy + uy;
        this.vec[6] = cx - vx + ux;
        this.vec[7] = cy - vy + uy;
        this.computeAxes();
    }

    public OBB2D(float cx, float cy, float width, float height) {
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        this.vec[0] = cx - hw;
        this.vec[1] = cy - hh;
        this.vec[2] = cx - hw;
        this.vec[3] = cy + hh;
        this.vec[4] = cx + hw;
        this.vec[5] = cy + hh;
        this.vec[6] = cx + hw;
        this.vec[7] = cy - hh;
        this.vec[8] = 0.0f;
        this.vec[9] = 1.0f / height;
        this.vec[10] = 1.0f / width;
        this.vec[11] = 0.0f;
        this.vec[0] = this.vec[1] * this.vec[9];
        this.vec[1] = this.vec[2] * this.vec[10];
    }

    public boolean overlaps(OBB2D other) {
        return this.overlaps1Way(other) && other.overlaps1Way(this);
    }

    public static class Vec2 {
        public static void set(float[] v, int pos, float x, float y) {
            v[pos + 0] = x;
            v[pos + 1] = y;
        }

        public static float dot(float[] v, int a, int b) {
            return v[a] * v[b] + v[a + 1] * v[b + 1];
        }

        public static final float lengthSquared(float[] v, int pos) {
            float x = v[pos + 0];
            float y = v[pos + 1];
            return x * x + y * y;
        }

        public static final void normalizeSquared(float[] v, int pos) {
            float x = v[pos + 0];
            float y = v[pos + 1];
            float length = x * x + y * y;
            v[pos + 0] = x / length;
            v[pos + 1] = y / length;
        }

        public static final void normalize(float[] v, int pos) {
            float x = v[pos + 0];
            float y = v[pos + 1];
            double length = Math.sqrt(x * x + y * y);
            v[pos + 0] = (float)((double)x / length);
            v[pos + 1] = (float)((double)y / length);
        }

        public static final float length(float[] v, int pos) {
            float x = v[pos + 0];
            float y = v[pos + 1];
            return (float)Math.sqrt(x * x + y * y);
        }

        public static final void add(float[] v, int r, int a, int b) {
            v[r + 0] = v[a + 0] + v[b + 0];
            v[r + 1] = v[a + 1] + v[b + 1];
        }

        public static final void sub(float[] v, int r, int a, int b) {
            v[r + 0] = v[a + 0] - v[b + 0];
            v[r + 1] = v[a + 1] - v[b + 1];
        }

        public static final void mul(float[] v, int pos, float a) {
            int n = pos + 0;
            v[n] = v[n] * a;
            int n2 = pos + 1;
            v[n2] = v[n2] * a;
        }
    }
}

