/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import java.util.Iterator;
import javax.annotation.CheckReturnValue;

public class Inlist<T extends Inlist<T>> {
    public T next;

    public T next() {
        return this.next;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T push(T list, T item) {
        if (item.next != null) {
            throw new IllegalArgumentException("'item' is a list");
        }
        item.next = list;
        return item;
    }

    public static <T extends Inlist<?>> int size(T list) {
        int count = 0;
        T l = list;
        while (l != null) {
            ++count;
            l = l.next;
        }
        return count;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T remove(T list, T item) {
        if (item == list) {
            T head = item.next;
            item.next = null;
            return head;
        }
        T prev = list;
        T it = list.next;
        while (it != null) {
            if (it == item) {
                prev.next = item.next;
                item.next = null;
                return list;
            }
            prev = it;
            it = ((Inlist)it).next;
        }
        return list;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T get(T list, int i) {
        if (i < 0) {
            return null;
        }
        while (--i > 0 && list != null) {
            list = list.next;
        }
        if (i == 0) {
            return list;
        }
        return null;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T appendItem(T list, T item) {
        if (item.next != null) {
            throw new IllegalArgumentException("'item' is list");
        }
        if (list == null) {
            return item;
        }
        T it = list;
        while (it.next != null) {
            it = it.next;
        }
        it.next = item;
        return list;
    }

    @CheckReturnValue
    public static <T extends Inlist> T appendList(T list, T other) {
        if (list == null) {
            return other;
        }
        if (other == null) {
            return list;
        }
        T it = list;
        while (true) {
            if (it.next == null) break;
            it = it.next;
        }
        it.next = other;
        return list;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T last(T list) {
        while (list != null) {
            if (list.next == null) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T prependRelative(T list, T item, T other) {
        if (item.next != null) {
            throw new IllegalArgumentException("'item' is list");
        }
        if (list == null) {
            throw new IllegalArgumentException("'list' is null");
        }
        if (list == other) {
            item.next = list;
            return item;
        }
        T it = list;
        while (it != null && it.next != other) {
            it = it.next;
        }
        if (it == null) {
            throw new IllegalArgumentException("'other' not in 'list'");
        }
        item.next = it.next;
        it.next = item;
        return list;
    }

    public static class List<T extends Inlist<?>>
    implements Iterable<T>,
    Iterator<T> {
        private Inlist head;
        private Inlist cur;

        public void push(T it) {
            if (((Inlist)it).next != null) {
                throw new IllegalArgumentException("item.next must be null");
            }
            ((Inlist)it).next = this.head;
            this.head = it;
        }

        public T pop() {
            if (this.head == null) {
                return null;
            }
            Inlist it = this.head;
            this.head = it.next;
            it.next = null;
            return (T)it;
        }

        public void reverse() {
            Inlist itr = this.head;
            this.head = null;
            while (itr != null) {
                Object tmp = itr.next;
                itr.next = this.head;
                this.head = itr;
                itr = tmp;
            }
        }

        public void append(T it) {
            this.head = Inlist.appendItem(this.head, it);
        }

        public void appendList(T list) {
            this.head = Inlist.appendList(this.head, list);
        }

        public void remove(T it) {
            this.cur = null;
            this.head = Inlist.remove(this.head, it);
        }

        public T clear() {
            Inlist ret = this.head;
            this.head = null;
            this.cur = null;
            return (T)ret;
        }

        public T head() {
            return (T)this.head;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public T next() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            Inlist tmp = this.cur;
            this.cur = this.cur.next;
            return (T)tmp;
        }

        @Override
        public void remove() {
            if (this.head.next == this.cur) {
                this.head = this.head.next;
                return;
            }
            Inlist prev = this.head;
            while (((Inlist)prev.next).next != this.cur) {
                prev = prev.next;
            }
            prev.next = this.cur;
        }

        @Override
        public Iterator<T> iterator() {
            this.cur = this.head;
            return this;
        }

        public int size() {
            return Inlist.size(this.head);
        }
    }
}

