/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.quadtree;

import java.util.Arrays;
import org.oscim.core.Box;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;
import org.oscim.utils.quadtree.TileIndex;
import org.oscim.utils.quadtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTree<T extends BoxItem<E>, E>
extends TileIndex<BoxNode<T>, T> {
    static final Logger log = LoggerFactory.getLogger(BoxTree.class);
    static boolean dbg = false;
    protected final int extents;
    protected final int maxDepth;
    private static final int MAX_STACK = 32;
    Pool<Stack<BoxNode<T>>> stackPool = new Pool<Stack<BoxNode<T>>>(){

        @Override
        protected Stack<BoxNode<T>> createItem() {
            return new Stack();
        }

        @Override
        protected boolean clearItem(Stack<BoxNode<T>> item) {
            if (item.tos != 0) {
                item.tos = 0;
                Arrays.fill(item.nodes, null);
            }
            return true;
        }
    };

    boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public BoxTree(int extents, int maxDepth) {
        if (!this.isPowerOfTwo(extents)) {
            throw new IllegalArgumentException("Extents must be power of two!");
        }
        ((BoxNode)this.root).x1 = -extents;
        ((BoxNode)this.root).y1 = -extents;
        ((BoxNode)this.root).x2 = extents;
        ((BoxNode)this.root).y2 = extents;
        this.extents = extents;
        this.maxDepth = maxDepth;
    }

    @Override
    public BoxNode<T> create() {
        return new BoxNode();
    }

    @Override
    public void removeItem(T item) {
    }

    public boolean search(BoxItem<?> box, SpatialIndex.SearchCb<E> cb, Object ctxt) {
        Stack<BoxNode<T>> stack = this.stackPool.get();
        stack.push((BoxNode<T>)this.root);
        while (!stack.empty()) {
            BoxNode<T> n = stack.pop();
            BoxItem it = (BoxItem)n.item;
            while (it != null) {
                if (it.overlaps(box) && !cb.call(it.item, ctxt)) {
                    this.stackPool.release(stack);
                    return false;
                }
                it = (BoxItem)it.next;
            }
            BoxNode p = (BoxNode)n.parent;
            switch (n.id) {
                case 0: {
                    if (BoxTree.overlaps((BoxNode)p.child01, box)) {
                        stack.push((BoxNode<T>)p.child01);
                        break;
                    }
                }
                case 1: {
                    if (BoxTree.overlaps((BoxNode)p.child10, box)) {
                        stack.push((BoxNode<T>)p.child10);
                        break;
                    }
                }
                case 2: {
                    if (!BoxTree.overlaps((BoxNode)p.child11, box)) break;
                    stack.push((BoxNode<T>)p.child11);
                    break;
                }
            }
            if (BoxTree.overlaps((BoxNode)n.child00, box)) {
                stack.push((BoxNode<T>)n.child00);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)n.child01, box)) {
                stack.push((BoxNode<T>)n.child01);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)n.child10, box)) {
                stack.push((BoxNode<T>)n.child10);
                continue;
            }
            if (!BoxTree.overlaps((BoxNode)n.child11, box)) continue;
            stack.push((BoxNode<T>)n.child11);
        }
        this.stackPool.release(stack);
        return true;
    }

    public boolean search(BoxItem<?> box, SearchBoxCb<T> cb) {
        if (((BoxNode)this.root).refs == 0) {
            return true;
        }
        Stack<BoxNode<T>> stack = this.stackPool.get();
        stack.push((BoxNode<T>)this.root);
        while (!stack.empty()) {
            BoxNode<T> n = stack.pop();
            BoxItem it = (BoxItem)n.item;
            while (it != null) {
                BoxItem item;
                if (it.overlaps(box) && !cb.call(item = it)) {
                    this.stackPool.release(stack);
                    return false;
                }
                it = (BoxItem)it.next;
            }
            BoxNode p = (BoxNode)n.parent;
            switch (n.id) {
                case 0: {
                    if (BoxTree.overlaps((BoxNode)p.child01, box)) {
                        stack.push((BoxNode<T>)p.child01);
                        break;
                    }
                }
                case 1: {
                    if (BoxTree.overlaps((BoxNode)p.child10, box)) {
                        stack.push((BoxNode<T>)p.child10);
                        break;
                    }
                }
                case 2: {
                    if (!BoxTree.overlaps((BoxNode)p.child11, box)) break;
                    stack.push((BoxNode<T>)p.child11);
                    break;
                }
            }
            if (BoxTree.overlaps((BoxNode)n.child00, box)) {
                stack.push((BoxNode<T>)n.child00);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)n.child01, box)) {
                stack.push((BoxNode<T>)n.child01);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)n.child10, box)) {
                stack.push((BoxNode<T>)n.child10);
                continue;
            }
            if (!BoxTree.overlaps((BoxNode)n.child11, box)) continue;
            stack.push((BoxNode<T>)n.child11);
        }
        this.stackPool.release(stack);
        return true;
    }

    private static boolean overlaps(BoxNode<?> a, BoxItem<?> b) {
        return a != null && a.x1 <= b.x2 && b.x1 <= a.x2 && a.y1 <= b.y2 && b.y1 <= a.y2;
    }

    public void collect(SearchNodeCb<BoxNode<T>> cb) {
        Stack<BoxNode<T>> stack = this.stackPool.get();
        stack.push((BoxNode<T>)this.root);
        while (!stack.empty()) {
            BoxNode<T> n = stack.pop();
            cb.call(n);
            BoxNode p = (BoxNode)n.parent;
            switch (n.id) {
                case 0: {
                    if (p.child01 != null) {
                        stack.push((BoxNode<T>)p.child01);
                        break;
                    }
                }
                case 1: {
                    if (p.child10 != null) {
                        stack.push((BoxNode<T>)p.child10);
                        break;
                    }
                }
                case 2: {
                    if (p.child11 == null) break;
                    stack.push((BoxNode<T>)p.child11);
                    break;
                }
            }
            if (n.child00 != null) {
                stack.push((BoxNode<T>)n.child00);
                continue;
            }
            if (n.child01 != null) {
                stack.push((BoxNode<T>)n.child01);
                continue;
            }
            if (n.child10 != null) {
                stack.push((BoxNode<T>)n.child10);
                continue;
            }
            if (n.child11 == null) continue;
            stack.push((BoxNode<T>)n.child11);
        }
        this.stackPool.release(stack);
    }

    public BoxNode<T> create(BoxNode<T> parent, int i) {
        BoxNode node;
        if (this.pool != null) {
            node = (BoxNode)this.pool;
            this.pool = ((BoxNode)this.pool).parent;
            node.refs = 0;
        } else {
            node = new BoxNode();
        }
        node.parent = parent;
        int size = parent.x2 - parent.x1 >> 1;
        node.x1 = parent.x1;
        node.y1 = parent.y1;
        if (i == 0) {
            parent.child00 = node;
        } else if (i == 1) {
            parent.child01 = node;
            node.y1 += size;
        } else if (i == 2) {
            parent.child10 = node;
            node.x1 += size;
        } else {
            parent.child11 = node;
            node.x1 += size;
            node.y1 += size;
        }
        node.x2 = node.x1 + size;
        node.y2 = node.y1 + size;
        node.id = (byte)i;
        return node;
    }

    public void insert(T box) {
        if (((BoxItem)box).x1 > ((BoxItem)box).x2 || ((BoxItem)box).y1 > ((BoxItem)box).y2) {
            throw new IllegalArgumentException();
        }
        if (((BoxItem)box).next != null) {
            throw new IllegalStateException("BoxItem is list");
        }
        BoxNode cur = (BoxNode)this.root;
        BoxNode child = null;
        int x1 = ((BoxItem)box).x1;
        int x2 = ((BoxItem)box).x2;
        int y1 = ((BoxItem)box).y1;
        int y2 = ((BoxItem)box).y2;
        for (int level = 0; level <= this.maxDepth; ++level) {
            ++cur.refs;
            int hsize = cur.x2 - cur.x1 >> 1;
            int cx = cur.x1 + hsize;
            int cy = cur.y1 + hsize;
            child = null;
            if (level < this.maxDepth) {
                if (x2 < cx) {
                    if (y2 < cy) {
                        child = (BoxNode)cur.child00;
                        if (child == null) {
                            child = this.create(cur, 0);
                        }
                    } else if (y1 >= cy && (child = (BoxNode)cur.child01) == null) {
                        child = this.create(cur, 1);
                    }
                }
                if (x1 >= cx) {
                    if (y2 < cy) {
                        child = (BoxNode)cur.child10;
                        if (child == null) {
                            child = this.create(cur, 2);
                        }
                    } else if (y1 >= cy && (child = (BoxNode)cur.child11) == null) {
                        child = this.create(cur, 3);
                    }
                }
            }
            if (child == null) {
                ((BoxItem)box).next = (Inlist)cur.item;
                cur.item = box;
                if (!dbg) break;
                log.debug("insert: " + level + " cnt:" + Inlist.size((Inlist)cur.item) + " " + x1 + ":" + y1 + " /" + x2 + "x" + y2 + " " + ((BoxItem)box).item);
                break;
            }
            cur = child;
        }
    }

    public boolean remove(T box, E item) {
        if (((BoxItem)box).x1 > ((BoxItem)box).x2 || ((BoxItem)box).y1 > ((BoxItem)box).y2) {
            throw new IllegalArgumentException();
        }
        BoxNode cur = (BoxNode)this.root;
        BoxNode child = null;
        int x1 = ((BoxItem)box).x1;
        int x2 = ((BoxItem)box).x2;
        int y1 = ((BoxItem)box).y1;
        int y2 = ((BoxItem)box).y2;
        for (int level = 0; level <= this.maxDepth; ++level) {
            int hsize = cur.x2 - cur.x1 >> 1;
            int cx = cur.x1 + hsize;
            int cy = cur.y1 + hsize;
            child = null;
            if (level < this.maxDepth) {
                if (x2 < cx) {
                    if (y2 < cy) {
                        child = (BoxNode)cur.child00;
                    } else if (y1 >= cy) {
                        child = (BoxNode)cur.child01;
                    }
                } else if (x1 >= cx) {
                    if (y2 < cy) {
                        child = (BoxNode)cur.child10;
                    } else if (y1 >= cy) {
                        child = (BoxNode)cur.child11;
                    }
                }
            }
            if (child == null) {
                BoxItem prev = (BoxItem)cur.item;
                BoxItem it = (BoxItem)cur.item;
                while (it != null) {
                    if (it.item == item) {
                        if (dbg) {
                            log.debug("remove: " + level + " cnt:" + Inlist.size((Inlist)cur.item) + " " + x1 + ":" + y1 + " /" + x2 + "x" + y2 + " " + item);
                        }
                        if (cur.item == it) {
                            BoxItem b = (BoxItem)it.next;
                            cur.item = b;
                        } else {
                            prev.next = it.next;
                        }
                        it.next = null;
                        this.remove(cur);
                        return true;
                    }
                    prev = it;
                    it = (BoxItem)it.next;
                }
                return false;
            }
            cur = child;
        }
        return false;
    }

    public BoxNode<T> getNode(T box, boolean create) {
        if (((BoxItem)box).x1 > ((BoxItem)box).x2 || ((BoxItem)box).y1 > ((BoxItem)box).y2) {
            throw new IllegalArgumentException();
        }
        BoxNode cur = (BoxNode)this.root;
        BoxNode child = null;
        int x1 = ((BoxItem)box).x1;
        int x2 = ((BoxItem)box).x2;
        int y1 = ((BoxItem)box).y1;
        int y2 = ((BoxItem)box).y2;
        for (int level = 0; level <= this.maxDepth; ++level) {
            ++cur.refs;
            int hsize = cur.x2 - cur.x1 >> 1;
            int cx = cur.x1 + hsize;
            int cy = cur.y1 + hsize;
            child = null;
            if (x2 < cx) {
                if (y2 < cy) {
                    child = (BoxNode)cur.child00;
                    if (child == null && create) {
                        child = this.create(cur, 0);
                    }
                } else if (y1 >= cy && (child = (BoxNode)cur.child01) == null && create) {
                    child = this.create(cur, 1);
                }
            }
            if (x1 >= cx) {
                if (y2 < cy) {
                    child = (BoxNode)cur.child10;
                    if (child == null && create) {
                        child = this.create(cur, 2);
                    }
                } else if (y1 >= cy && (child = (BoxNode)cur.child11) == null && create) {
                    child = this.create(cur, 3);
                }
            }
            if (child == null || level == this.maxDepth) {
                return cur;
            }
            cur = child;
        }
        return null;
    }

    public void clear() {
        ((BoxNode)this.root).child00 = null;
        ((BoxNode)this.root).child01 = null;
        ((BoxNode)this.root).child10 = null;
        ((BoxNode)this.root).child11 = null;
        ((BoxNode)this.root).item = null;
        ((BoxNode)this.root).refs = 0;
    }

    public void clearToPool() {
        BoxNode node = (BoxNode)this.root;
        while (true) {
            if (node.child00 != null) {
                node = (BoxNode)node.child00;
                continue;
            }
            if (node.child01 != null) {
                node = (BoxNode)node.child01;
                continue;
            }
            if (node.child10 != null) {
                node = (BoxNode)node.child10;
                continue;
            }
            if (node.child11 != null) {
                node = (BoxNode)node.child11;
                continue;
            }
            if (node == this.root) break;
            BoxNode parent = (BoxNode)node.parent;
            switch (node.id) {
                case 0: {
                    parent.child00 = null;
                    break;
                }
                case 1: {
                    parent.child01 = null;
                    break;
                }
                case 2: {
                    parent.child10 = null;
                    break;
                }
                case 3: {
                    parent.child11 = null;
                }
            }
            node.item = null;
            node.refs = 0;
            node.parent = this.pool;
            this.pool = node;
            node = parent;
        }
        ((BoxNode)this.root).child00 = null;
        ((BoxNode)this.root).child01 = null;
        ((BoxNode)this.root).child10 = null;
        ((BoxNode)this.root).child11 = null;
        ((BoxNode)this.root).item = null;
        ((BoxNode)this.root).refs = 0;
    }

    @Override
    public int size() {
        return ((BoxNode)this.root).refs;
    }

    public static interface SearchNodeCb<E extends BoxNode<?>> {
        public boolean call(E var1);
    }

    public static interface SearchBoxCb<T extends BoxItem<?>> {
        public boolean call(T var1);
    }

    public static interface Visitor<T> {
        public boolean process(T var1);
    }

    public static class BoxItem<T>
    extends Inlist<BoxItem<T>> {
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public T item;

        public BoxItem() {
        }

        public BoxItem(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public BoxItem(float x1, float y1, float x2, float y2) {
            this.x1 = (int)x1;
            this.y1 = (int)y1;
            this.x2 = (int)x2;
            this.y2 = (int)y2;
        }

        public BoxItem(Box box, T item) {
            this.x1 = (int)box.xmin;
            this.y1 = (int)box.ymin;
            this.x2 = (int)box.xmax;
            this.y2 = (int)box.ymax;
            this.item = item;
        }

        public boolean overlaps(BoxItem<?> it) {
            return this.x1 <= it.x2 && it.x1 <= this.x2 && this.y1 <= it.y2 && it.y1 <= this.y2;
        }

        public void setExtents(float[] obb, float add) {
            this.setExtents(obb, add, obb.length);
        }

        public void setExtents(float[] obb, float add, int length) {
            float y2;
            float x2;
            float x1 = x2 = obb[0];
            float y1 = y2 = obb[1];
            int n = length;
            for (int i = 2; i < n; i += 2) {
                float x = obb[i];
                if (x < x1) {
                    x1 = x;
                } else if (x > x2) {
                    x2 = x;
                }
                float y = obb[i + 1];
                if (y < y1) {
                    y1 = y;
                    continue;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
            this.x1 = (int)(x1 - add);
            this.y1 = (int)(y1 - add);
            this.x2 = (int)(x2 + add);
            this.y2 = (int)(y2 + add);
        }

        public String toString() {
            return "[" + this.x1 + ',' + this.y1 + '/' + this.x2 + ',' + this.y2 + ']';
        }
    }

    public static class BoxNode<T extends BoxItem<?>>
    extends TreeNode<BoxNode<T>, T> {
        public int x1;
        public int x2;
        public int y1;
        public int y2;

        public String toString() {
            return this.x1 + ":" + this.y1 + ":" + (this.x2 - this.x1);
        }
    }

    static class Stack<E>
    extends Inlist<Stack<E>> {
        int tos;
        final E[] nodes = new BoxNode[32];

        Stack() {
        }

        void push(E node) {
            this.nodes[this.tos] = node;
            ++this.tos;
        }

        E pop() {
            this.nodes[this.tos--] = null;
            return this.nodes[this.tos];
        }

        E node() {
            return this.nodes[this.tos];
        }

        boolean empty() {
            return this.tos <= 0;
        }
    }
}

