/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker.utils;

import org.oscim.layers.marker.utils.GrowingArrayUtils;

public class SparseIntArray
implements Cloneable {
    private int[] mKeys;
    private int[] mValues;
    private int mSize;

    public SparseIntArray(int initialCapacity) {
        if (initialCapacity == 0) {
            initialCapacity = 100;
        }
        this.mKeys = new int[initialCapacity];
        this.mValues = new int[this.mKeys.length];
        this.mSize = 0;
    }

    public SparseIntArray clone() {
        SparseIntArray clone = null;
        try {
            clone = (SparseIntArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (int[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int get(int key) {
        return this.get(key, 0);
    }

    public int get(int key, int valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, int value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public int valueAt(int index) {
        return this.mValues[index];
    }

    public void setValueAt(int index, int value) {
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(int value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, int value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            int value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    static class ContainerHelpers {
        ContainerHelpers() {
        }

        static int binarySearch(int[] array, int size, int value) {
            int lo = 0;
            int hi = size - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = array[mid];
                if (midVal < value) {
                    lo = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }

        static int binarySearch(long[] array, int size, long value) {
            int lo = 0;
            int hi = size - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                long midVal = array[mid];
                if (midVal < value) {
                    lo = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }
    }
}

