/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeMenuCallback;

public class ExternalRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final long mFileModificationDate;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mPath;

    public ExternalRenderTheme(String fileName) throws IRenderTheme.ThemeException {
        this(fileName, null);
    }

    public ExternalRenderTheme(String fileName, XmlRenderThemeMenuCallback menuCallback) throws IRenderTheme.ThemeException {
        File themeFile = new File(fileName);
        if (!themeFile.exists()) {
            throw new IRenderTheme.ThemeException("file does not exist: " + themeFile.getAbsolutePath());
        }
        if (!themeFile.isFile()) {
            throw new IRenderTheme.ThemeException("not a file: " + fileName);
        }
        if (!themeFile.canRead()) {
            throw new IRenderTheme.ThemeException("cannot read file: " + fileName);
        }
        this.mFileModificationDate = themeFile.lastModified();
        if (this.mFileModificationDate == 0L) {
            throw new IRenderTheme.ThemeException("cannot read last modification time");
        }
        this.mPath = fileName;
        this.mMenuCallback = menuCallback;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalRenderTheme)) {
            return false;
        }
        ExternalRenderTheme other = (ExternalRenderTheme)obj;
        if (this.mFileModificationDate != other.mFileModificationDate) {
            return false;
        }
        if (this.mPath == null && other.mPath != null) {
            return false;
        }
        return this.mPath == null || this.mPath.equals(other.mPath);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return new File(this.mPath).getParent();
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        FileInputStream is;
        try {
            is = new FileInputStream(this.mPath);
        }
        catch (FileNotFoundException e) {
            throw new IRenderTheme.ThemeException(e.getMessage());
        }
        return is;
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback menuCallback) {
        this.mMenuCallback = menuCallback;
    }
}

