/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.ThemeLoader;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static TextureItem loadTexture(String relativePathPrefix, String src, int width, int height, int percent) {
        if (src == null || src.length() == 0) {
            return null;
        }
        try {
            Bitmap bitmap = CanvasAdapter.getBitmapAsset(relativePathPrefix, src, width, height, percent);
            if (bitmap != null) {
                log.debug("loading {}", (Object)src);
                if (ThemeLoader.POT_TEXTURES) {
                    int potWidth = MathUtils.nextPowerOfTwo(bitmap.getWidth());
                    int potHeight = MathUtils.nextPowerOfTwo(bitmap.getHeight());
                    if (potWidth != bitmap.getWidth() || potHeight != bitmap.getHeight()) {
                        log.debug("POT texture: {}x{} -> {}x{}", new Object[]{bitmap.getWidth(), bitmap.getHeight(), potWidth, potHeight});
                        Bitmap potBitmap = CanvasAdapter.newBitmap(potWidth, potHeight, 0);
                        Canvas canvas = CanvasAdapter.newCanvas();
                        canvas.setBitmap(potBitmap);
                        canvas.drawBitmapScaled(bitmap);
                        bitmap = potBitmap;
                    }
                }
                return new TextureItem(bitmap, true);
            }
        }
        catch (Exception e) {
            log.debug("missing file / {}", (Object)e.getMessage());
        }
        return null;
    }

    private Utils() {
        throw new IllegalStateException();
    }
}

