/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.io.Serializable;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.utils.FastMath;

public class GeoPoint
implements Comparable<GeoPoint>,
Serializable {
    private static final long serialVersionUID = 8965378345755560352L;
    private static final double CONVERSION_FACTOR = 1000000.0;
    private static final double EQUATORIAL_RADIUS = 6378137.0;
    private static final double INVERSE_FLATTENING = 298.257223563;
    private static final double POLAR_RADIUS = 6356752.3142;
    private int hashCodeValue = 0;
    public final int latitudeE6;
    public final int longitudeE6;

    public GeoPoint(double lat, double lon) {
        lat = FastMath.clamp(lat, -85.05112877980659, 85.05112877980659);
        this.latitudeE6 = (int)(lat * 1000000.0);
        lon = FastMath.clamp(lon, -180.0, 180.0);
        this.longitudeE6 = (int)(lon * 1000000.0);
    }

    public GeoPoint(int latitudeE6, int longitudeE6) {
        this((double)latitudeE6 / 1000000.0, (double)longitudeE6 / 1000000.0);
    }

    public double bearingTo(GeoPoint other) {
        double deltaLon = Math.toRadians(other.getLongitude() - this.getLongitude());
        double a1 = Math.toRadians(this.getLatitude());
        double b1 = Math.toRadians(other.getLatitude());
        double y = Math.sin(deltaLon) * Math.cos(b1);
        double x = Math.cos(a1) * Math.sin(b1) - Math.sin(a1) * Math.cos(b1) * Math.cos(deltaLon);
        double result = Math.toDegrees(Math.atan2(y, x));
        return (result + 360.0) % 360.0;
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + this.latitudeE6;
        result = 31 * result + this.longitudeE6;
        return result;
    }

    @Override
    public int compareTo(GeoPoint geoPoint) {
        if (this.equals(geoPoint)) {
            return 0;
        }
        if (this.longitudeE6 > geoPoint.longitudeE6) {
            return 1;
        }
        if (this.longitudeE6 < geoPoint.longitudeE6) {
            return -1;
        }
        if (this.latitudeE6 > geoPoint.latitudeE6) {
            return 1;
        }
        if (this.latitudeE6 < geoPoint.latitudeE6) {
            return -1;
        }
        return 0;
    }

    public GeoPoint destinationPoint(double distance, float bearing) {
        double theta = Math.toRadians(bearing);
        double delta = distance / 6378137.0;
        double phi1 = Math.toRadians(this.getLatitude());
        double lambda1 = Math.toRadians(this.getLongitude());
        double phi2 = Math.asin(Math.sin(phi1) * Math.cos(delta) + Math.cos(phi1) * Math.sin(delta) * Math.cos(theta));
        double lambda2 = lambda1 + Math.atan2(Math.sin(theta) * Math.sin(delta) * Math.cos(phi1), Math.cos(delta) - Math.sin(phi1) * Math.sin(phi2));
        return new GeoPoint(Math.toDegrees(phi2), Math.toDegrees(lambda2));
    }

    public double distance(GeoPoint other) {
        return Math.hypot(this.getLongitude() - other.getLongitude(), this.getLatitude() - other.getLatitude());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoPoint)) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        if (Math.abs(this.latitudeE6 - other.latitudeE6) > 1) {
            return false;
        }
        return Math.abs(this.longitudeE6 - other.longitudeE6) <= 1;
    }

    public double getLatitude() {
        return (double)this.latitudeE6 / 1000000.0;
    }

    public double getLongitude() {
        return (double)this.longitudeE6 / 1000000.0;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.calculateHashCode();
        }
        return this.hashCodeValue;
    }

    public static double latitudeDistance(int meters) {
        return (double)(meters * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int meters, double latitude) {
        return (double)(meters * 360) / (4.007501668557849E7 * Math.cos(Math.toRadians(latitude)));
    }

    public void project(Point out) {
        out.x = MercatorProjection.longitudeToX((double)this.longitudeE6 / 1000000.0);
        out.y = MercatorProjection.latitudeToY((double)this.latitudeE6 / 1000000.0);
    }

    public double sphericalDistance(GeoPoint other) {
        double dLat = Math.toRadians(other.getLatitude() - this.getLatitude());
        double dLon = Math.toRadians(other.getLongitude() - this.getLongitude());
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(this.getLatitude())) * Math.cos(Math.toRadians(other.getLatitude())) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6378137.0;
    }

    public String toString() {
        return "[lat=" + this.getLatitude() + ",lon=" + this.getLongitude() + "]";
    }

    public double vincentyDistance(GeoPoint other) {
        double lambdaP;
        double C;
        double f = 0.0033528106647474805;
        double L = Math.toRadians(other.getLongitude() - this.getLongitude());
        double U1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(this.getLatitude())));
        double U2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(other.getLatitude())));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        double cosSqAlpha = 0.0;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double cos2SigmaM = 0.0;
        double sigma = 0.0;
        double sinLambda = 0.0;
        double sinAlpha = 0.0;
        double cosLambda = 0.0;
        do {
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) != 0.0) continue;
            return 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda)) + C * sinSigma * ((cos2SigmaM = (cosSqAlpha = 1.0 - (sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma) * sinAlpha) != 0.0 ? cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha : 0.0) + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return 0.0;
        }
        double uSq = cosSqAlpha * (Math.pow(6378137.0, 2.0) - Math.pow(6356752.3142, 2.0)) / Math.pow(6356752.3142, 2.0);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double s = 6356752.3142 * A * (sigma - deltaSigma);
        return s;
    }
}

