/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;

public class Tile {
    private static final int DEFAULT_TILE_SIZE = 256;
    public static int SIZE = 512;
    public static int TILE_SIZE_MULTIPLE = 64;
    public final long mapSize;
    public final int tileX;
    public final int tileY;
    public final byte zoomLevel;
    private BoundingBox boundingBox;
    private Point origin;
    private int mHash = 0;

    public Tile(int tileX, int tileY, byte zoomLevel) {
        this.tileX = tileX;
        this.tileY = tileY;
        this.zoomLevel = zoomLevel;
        this.mapSize = MercatorProjection.getMapSize(zoomLevel);
    }

    public String toString() {
        return "[X:" + this.tileX + ", Y:" + this.tileY + ", Z:" + this.zoomLevel + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile o = (Tile)obj;
        return o.tileX == this.tileX && o.tileY == this.tileY && o.zoomLevel == this.zoomLevel;
    }

    public int hashCode() {
        if (this.mHash == 0) {
            int result = 7;
            result = 31 * result + this.tileX;
            result = 31 * result + this.tileY;
            this.mHash = result = 31 * result + this.zoomLevel;
        }
        return this.mHash;
    }

    public static int calculateTileSize() {
        float scaled = 256.0f * CanvasAdapter.getScale();
        return Math.max(TILE_SIZE_MULTIPLE, Math.round(scaled / (float)TILE_SIZE_MULTIPLE) * TILE_SIZE_MULTIPLE);
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            double minLatitude = Math.max(-85.05112877980659, MercatorProjection.tileYToLatitude(this.tileY + 1, this.zoomLevel));
            double minLongitude = Math.max(-180.0, MercatorProjection.tileXToLongitude(this.tileX, this.zoomLevel));
            double maxLatitude = Math.min(85.05112877980659, MercatorProjection.tileYToLatitude(this.tileY, this.zoomLevel));
            double maxLongitude = Math.min(180.0, MercatorProjection.tileXToLongitude(this.tileX + 1, this.zoomLevel));
            if (maxLongitude == -180.0) {
                maxLongitude = 180.0;
            }
            this.boundingBox = new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        }
        return this.boundingBox;
    }

    public static BoundingBox getBoundingBox(Tile upperLeft, Tile lowerRight) {
        BoundingBox ul = upperLeft.getBoundingBox();
        BoundingBox lr = lowerRight.getBoundingBox();
        return ul.extendBoundingBox(lr);
    }

    public static int getMaxTileNumber(byte zoomLevel) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoomLevel must not be negative: " + zoomLevel);
        }
        if (zoomLevel == 0) {
            return 0;
        }
        return (2 << zoomLevel - 1) - 1;
    }

    public Point getOrigin() {
        if (this.origin == null) {
            double x = MercatorProjection.tileToPixel(this.tileX);
            double y = MercatorProjection.tileToPixel(this.tileY);
            this.origin = new Point(x, y);
        }
        return this.origin;
    }
}

