/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.MercatorProjection;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.LocationRenderer;

public class LocationLayer
extends Layer {
    public final LocationRenderer locationRenderer;

    public LocationLayer(Map map) {
        this(map, CanvasAdapter.getScale());
    }

    public LocationLayer(Map map, float scale) {
        super(map);
        this.locationRenderer = new LocationRenderer(this.mMap, this, scale);
        this.mRenderer = this.locationRenderer;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (!enabled) {
            this.locationRenderer.animate(false);
        }
    }

    public void setPosition(double latitude, double longitude, double accuracy) {
        double x = MercatorProjection.longitudeToX(longitude);
        double y = MercatorProjection.latitudeToY(latitude);
        double radius = accuracy / MercatorProjection.groundResolutionWithScale(latitude, 1.0);
        this.locationRenderer.setLocation(x, y, radius);
        this.locationRenderer.animate(true);
    }
}

