/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import java.util.Comparator;
import org.oscim.layers.tile.MapTile;
import org.oscim.utils.TimSort;

public class TileDistanceSort
extends TimSort<MapTile> {
    static TileDistanceSort INSTANCE = new TileDistanceSort();
    static final Comparator<MapTile> DistanceComparator = new Comparator<MapTile>(){

        @Override
        public int compare(MapTile a, MapTile b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a.distance < b.distance) {
                return -1;
            }
            if (a.distance > b.distance) {
                return 1;
            }
            return 0;
        }
    };

    private TileDistanceSort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(MapTile[] a, int lo, int hi) {
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        TileDistanceSort tileDistanceSort = INSTANCE;
        synchronized (tileDistanceSort) {
            INSTANCE.doSort(a, DistanceComparator, lo, hi);
        }
    }
}

