/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.oscim.core.MapElement;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.OffscreenRenderer;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.RenderStyle;

public class BuildingLayer
extends Layer
implements VectorTileLayer.TileLoaderThemeHook {
    private static final int BUILDING_LEVEL_HEIGHT = 280;
    private static final int MIN_ZOOM = 17;
    private static final int MAX_ZOOM = 17;
    public static boolean POST_AA = false;
    public static boolean TRANSLUCENT = true;
    private static final Object BUILDING_DATA = BuildingLayer.class.getName();
    private HashMap<Integer, List<BuildingElement>> mBuildings = new HashMap();

    public BuildingLayer(Map map, VectorTileLayer tileLayer) {
        this(map, tileLayer, 17, 17, false);
    }

    public BuildingLayer(Map map, VectorTileLayer tileLayer, boolean mesh) {
        this(map, tileLayer, 17, 17, mesh);
    }

    public BuildingLayer(Map map, VectorTileLayer tileLayer, int zoomMin, int zoomMax, boolean mesh) {
        super(map);
        tileLayer.addHook(this);
        this.mRenderer = new BuildingRenderer(tileLayer.tileRenderer(), zoomMin, zoomMax, mesh, !mesh && TRANSLUCENT);
        if (POST_AA) {
            this.mRenderer = new OffscreenRenderer(OffscreenRenderer.Mode.SSAO_FXAA, this.mRenderer);
        }
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        boolean isBuildingPart;
        if (!(style instanceof ExtrusionStyle)) {
            return false;
        }
        ExtrusionStyle extrusion = (ExtrusionStyle)style.current();
        boolean bl = isBuildingPart = element.tags.containsKey("building:part") || element.tags.containsKey("kind") && element.tags.getValue("kind").equals("building_part");
        if (element.tags.containsKey("building") || isBuildingPart || element.tags.containsKey("kind") && element.tags.getValue("kind").equals("building")) {
            List<BuildingElement> buildingElements = this.mBuildings.get(tile.hashCode());
            if (buildingElements == null) {
                buildingElements = new ArrayList<BuildingElement>();
                this.mBuildings.put(tile.hashCode(), buildingElements);
            }
            element = new MapElement(element);
            buildingElements.add(new BuildingElement(element, extrusion, isBuildingPart));
            return true;
        }
        this.processElement(element, extrusion, tile);
        return true;
    }

    private void processElement(MapElement element, ExtrusionStyle extrusion, MapTile tile) {
        int height = 0;
        int minHeight = 0;
        String v = element.tags.getValue("height");
        if (v != null) {
            height = (int)(Float.parseFloat(v) * 100.0f);
        } else {
            v = element.tags.getValue("building:levels");
            if (v != null) {
                height = (int)(Float.parseFloat(v) * 280.0f);
            }
        }
        v = element.tags.getValue("min_height");
        if (v != null) {
            minHeight = (int)(Float.parseFloat(v) * 100.0f);
        } else {
            v = element.tags.getValue("building:min_level");
            if (v != null) {
                minHeight = (int)(Float.parseFloat(v) * 280.0f);
            }
        }
        if (height == 0) {
            height = extrusion.defaultHeight * 100;
        }
        ExtrusionBuckets ebs = BuildingLayer.get(tile);
        ebs.addPolyElement(element, tile.getGroundScale(), extrusion.colors, height, minHeight);
    }

    private void processElements(MapTile tile) {
        if (!this.mBuildings.containsKey(tile.hashCode())) {
            return;
        }
        List<BuildingElement> tileBuildings = this.mBuildings.get(tile.hashCode());
        HashSet<BuildingElement> rootBuildings = new HashSet<BuildingElement>();
        block0: for (BuildingElement partBuilding : tileBuildings) {
            if (!partBuilding.isPart) continue;
            String refId = partBuilding.element.tags.getValue("ref");
            String string = refId = refId == null ? partBuilding.element.tags.getValue("root_id") : refId;
            if (refId == null) continue;
            for (BuildingElement rootBuilding : tileBuildings) {
                if (rootBuilding.isPart || !refId.equals(rootBuilding.element.tags.getValue("id"))) continue;
                rootBuildings.add(rootBuilding);
                continue block0;
            }
        }
        tileBuildings.removeAll(rootBuildings);
        for (BuildingElement buildingElement : tileBuildings) {
            this.processElement(buildingElement.element, buildingElement.style, tile);
        }
        this.mBuildings.remove(tile.hashCode());
    }

    public static ExtrusionBuckets get(MapTile tile) {
        ExtrusionBuckets ebs = (ExtrusionBuckets)tile.getData(BUILDING_DATA);
        if (ebs == null) {
            ebs = new ExtrusionBuckets(tile);
            tile.addData(BUILDING_DATA, ebs);
        }
        return ebs;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
        if (success) {
            this.processElements(tile);
            BuildingLayer.get(tile).prepare();
        } else {
            BuildingLayer.get(tile).resetBuckets(null);
        }
    }

    class BuildingElement {
        MapElement element;
        ExtrusionStyle style;
        boolean isPart;

        BuildingElement(MapElement element, ExtrusionStyle style, boolean isPart) {
            this.element = element;
            this.style = style;
            this.isPart = isPart;
        }
    }
}

