/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.TileSet;
import org.oscim.layers.tile.vector.labeling.Label;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelPool;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.SymbolBucket;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.OBB2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelPlacement {
    static final boolean dbg = false;
    static final Logger log = LoggerFactory.getLogger(LabelPlacement.class);
    private static final float MIN_CAPTION_DIST = 5.0f;
    private static final float MIN_WAY_DIST = 3.0f;
    private final LabelPool mPool = new LabelPool();
    private final TileSet mTileSet = new TileSet();
    private final TileRenderer mTileRenderer;
    private final Map mMap;
    private Label mLabels;
    private float mSquareRadius;
    private int mRelabelCnt;

    public static final LabelTileData getLabels(MapTile tile) {
        return (LabelTileData)tile.getData(LabelLayer.LABEL_DATA);
    }

    public LabelPlacement(Map map, TileRenderer tileRenderer) {
        this.mMap = map;
        this.mTileRenderer = tileRenderer;
    }

    private Label removeLabel(Label l) {
        Label ret = (Label)l.next;
        this.mLabels = this.mPool.release(this.mLabels, l);
        return ret;
    }

    public void addLabel(Label l) {
        l.next = this.mLabels;
        this.mLabels = l;
    }

    private byte checkOverlap(Label l) {
        Label o = this.mLabels;
        while (o != null) {
            if (!Label.bboxOverlaps(l, o, 100.0f)) {
                o = (Label)o.next;
                continue;
            }
            if (Label.shareText(l, o)) {
                if (o.active <= l.active) {
                    return 1;
                }
                if (o.length < l.length) {
                    o = this.removeLabel(o);
                    continue;
                }
                return 2;
            }
            if (l.bbox.overlaps(o.bbox)) {
                if (o.active <= l.active) {
                    return 1;
                }
                if (!(o.text.caption || o.text.priority <= l.text.priority && o.length >= l.length)) {
                    o = this.removeLabel(o);
                    continue;
                }
                return 1;
            }
            o = (Label)o.next;
        }
        return 0;
    }

    private boolean isVisible(float x, float y) {
        float dist = x * x + y * y;
        return !(dist > this.mSquareRadius);
    }

    private boolean wayIsVisible(Label ti) {
        float dist = ti.x * ti.x + ti.y * ti.y;
        if (dist < this.mSquareRadius) {
            return true;
        }
        dist = ti.x1 * ti.x1 + ti.y1 * ti.y1;
        if (dist < this.mSquareRadius) {
            return true;
        }
        dist = ti.x2 * ti.x2 + ti.y2 * ti.y2;
        return dist < this.mSquareRadius;
    }

    private Label getLabel() {
        Label l = (Label)this.mPool.get();
        l.active = Integer.MAX_VALUE;
        return l;
    }

    private static float flipLongitude(float dx, int max) {
        if (dx > (float)max) {
            dx -= (float)(max * 2);
        } else if (dx < (float)(-max)) {
            dx += (float)(max * 2);
        }
        return dx;
    }

    private void placeLabelFrom(Label l, TextItem ti) {
        float w = (ti.x2 - ti.x1) / 2.0f;
        float h = (ti.y2 - ti.y1) / 2.0f;
        l.x1 = l.x - w;
        l.y1 = l.y - h;
        l.x2 = l.x + w;
        l.y2 = l.y + h;
    }

    private Label addWayLabels(MapTile t, Label l, float dx, float dy, double scale) {
        LabelTileData ld = LabelPlacement.getLabels(t);
        if (ld == null) {
            return l;
        }
        for (TextItem ti : ld.labels) {
            if (ti.text.caption) continue;
            if (l == null) {
                l = this.getLabel();
            }
            if ((double)ti.width > (double)ti.length * scale) continue;
            l.clone(ti);
            l.x = (float)((double)(dx + ti.x) * scale);
            l.y = (float)((double)(dy + ti.y) * scale);
            this.placeLabelFrom(l, ti);
            if (!this.wayIsVisible(l)) continue;
            int overlaps = -1;
            if (l.bbox == null) {
                l.bbox = new OBB2D(l.x, l.y, l.x1, l.y1, l.width + 3.0f, l.text.fontHeight + 3.0f);
            } else {
                l.bbox.set(l.x, l.y, l.x1, l.y1, l.width + 3.0f, l.text.fontHeight + 3.0f);
            }
            if ((double)ti.width < (double)ti.length * scale) {
                overlaps = this.checkOverlap(l);
            }
            if (overlaps != 0) continue;
            this.addLabel(l);
            l.item = TextItem.copy(ti);
            l.tileX = t.tileX;
            l.tileY = t.tileY;
            l.tileZ = t.zoomLevel;
            l.active = this.mRelabelCnt;
            l = null;
        }
        return l;
    }

    private Label addNodeLabels(MapTile t, Label l, float dx, float dy, double scale, float cos, float sin) {
        LabelTileData ld = LabelPlacement.getLabels(t);
        if (ld == null) {
            return l;
        }
        block0: for (TextItem ti : ld.labels) {
            if (!ti.text.caption) continue;
            if (l == null) {
                l = this.getLabel();
            }
            l.clone(ti);
            l.x = (float)((double)(dx + ti.x) * scale);
            l.y = (float)((double)(dy + ti.y) * scale);
            if (!this.isVisible(l.x, l.y)) continue;
            if (l.bbox == null) {
                l.bbox = new OBB2D();
            }
            l.bbox.setNormalized(l.x, l.y, cos, -sin, l.width + 5.0f, l.text.fontHeight + 5.0f, l.text.dy);
            Label o = this.mLabels;
            while (o != null) {
                if (l.bbox.overlaps(o.bbox)) {
                    if (l.text.priority >= o.text.priority) continue block0;
                    o = this.removeLabel(o);
                    continue;
                }
                o = (Label)o.next;
            }
            this.addLabel(l);
            l.item = TextItem.copy(ti);
            l.tileX = t.tileX;
            l.tileY = t.tileY;
            l.tileZ = t.zoomLevel;
            l.active = this.mRelabelCnt;
            l = null;
        }
        return l;
    }

    boolean updateLabels(LabelTask work) {
        int i;
        float dy;
        float dx;
        boolean changedTiles = this.mTileRenderer.getVisibleTiles(this.mTileSet);
        if (this.mTileSet.cnt == 0) {
            return false;
        }
        MapPosition pos = work.pos;
        boolean changedPos = this.mMap.viewport().getMapPosition(pos);
        if (!changedTiles && !changedPos) {
            return false;
        }
        ++this.mRelabelCnt;
        MapTile[] tiles = this.mTileSet.tiles;
        byte zoom = tiles[0].zoomLevel;
        int mw = (this.mMap.getWidth() + Tile.SIZE) / 2;
        int mh = (this.mMap.getHeight() + Tile.SIZE) / 2;
        this.mSquareRadius = mw * mw + mh * mh;
        double scale = pos.scale / (double)(1 << zoom);
        double angle = Math.toRadians(pos.bearing);
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        int maxx = Tile.SIZE << zoom - 1;
        SymbolBucket sl = work.symbolLayer;
        sl.clearItems();
        double tileX = pos.x * (double)(Tile.SIZE << zoom);
        double tileY = pos.y * (double)(Tile.SIZE << zoom);
        Label prevLabels = this.mLabels;
        this.mLabels = null;
        Label l = null;
        l = prevLabels;
        while (l != null) {
            if (l.text.caption) {
                l = this.mPool.releaseAndGetNext(l);
                continue;
            }
            int diff = l.tileZ - zoom;
            if (diff > 1 || diff < -1) {
                l = this.mPool.releaseAndGetNext(l);
                continue;
            }
            float div = FastMath.pow(diff);
            float sscale = (float)(pos.scale / (double)(1 << l.tileZ));
            if (l.width > (float)(l.length + 10) * sscale) {
                l = this.mPool.releaseAndGetNext(l);
                continue;
            }
            dx = (float)((double)(l.tileX * Tile.SIZE) - tileX * (double)div);
            dy = (float)((double)(l.tileY * Tile.SIZE) - tileY * (double)div);
            dx = LabelPlacement.flipLongitude(dx, maxx);
            l.x = (dx + l.item.x) * sscale;
            l.y = (dy + l.item.y) * sscale;
            this.placeLabelFrom(l, l.item);
            if (!this.wayIsVisible(l)) {
                l = this.mPool.releaseAndGetNext(l);
                continue;
            }
            l.bbox.set(l.x, l.y, l.x1, l.y1, l.width + 3.0f, l.text.fontHeight + 3.0f);
            byte overlaps = this.checkOverlap(l);
            if (overlaps == 0) {
                Label ll = l;
                l = (Label)l.next;
                ll.next = null;
                this.addLabel(ll);
                continue;
            }
            l = this.mPool.releaseAndGetNext(l);
        }
        int n = this.mTileSet.cnt;
        for (i = 0; i < n; ++i) {
            MapTile t = tiles[i];
            if (!t.state(12)) continue;
            dx = (float)((double)(t.tileX * Tile.SIZE) - tileX);
            dy = (float)((double)(t.tileY * Tile.SIZE) - tileY);
            dx = LabelPlacement.flipLongitude(dx, maxx);
            l = this.addWayLabels(t, l, dx, dy, scale);
        }
        n = this.mTileSet.cnt;
        for (i = 0; i < n; ++i) {
            MapTile t = tiles[i];
            if (!t.state(12)) continue;
            dx = (float)((double)(t.tileX * Tile.SIZE) - tileX);
            dy = (float)((double)(t.tileY * Tile.SIZE) - tileY);
            dx = LabelPlacement.flipLongitude(dx, maxx);
            l = this.addNodeLabels(t, l, dx, dy, scale, cos, sin);
        }
        Label ti = this.mLabels;
        while (ti != null) {
            if (ti.text.caption) {
                if (ti.text.bitmap != null || ti.text.texture != null) {
                    SymbolItem s = SymbolItem.pool.get();
                    if (ti.text.bitmap != null) {
                        s.bitmap = ti.text.bitmap;
                    } else {
                        s.texRegion = ti.text.texture;
                    }
                    s.x = ti.x;
                    s.y = ti.y;
                    s.billboard = true;
                    sl.addSymbol(s);
                }
            } else if (cos * (ti.x2 - ti.x1) - sin * (ti.y2 - ti.y1) < 0.0f) {
                float tmp = ti.x1;
                ti.x1 = ti.x2;
                ti.x2 = tmp;
                tmp = ti.y1;
                ti.y1 = ti.y2;
                ti.y2 = tmp;
            }
            ti = (Label)ti.next;
        }
        n = this.mTileSet.cnt;
        for (int i2 = 0; i2 < n; ++i2) {
            MapTile t = tiles[i2];
            if (!t.state(12)) continue;
            dx = (float)((double)(t.tileX * Tile.SIZE) - tileX);
            dy = (float)((double)(t.tileY * Tile.SIZE) - tileY);
            dx = LabelPlacement.flipLongitude(dx, maxx);
            LabelTileData ld = LabelPlacement.getLabels(t);
            if (ld == null) continue;
            for (SymbolItem ti2 : ld.symbols) {
                int y;
                int x;
                if (ti2.bitmap == null && ti2.texRegion == null || !this.isVisible(x = (int)((double)(dx + ti2.x) * scale), y = (int)((double)(dy + ti2.y) * scale))) continue;
                SymbolItem s = SymbolItem.pool.get();
                if (ti2.bitmap != null) {
                    s.bitmap = ti2.bitmap;
                } else {
                    s.texRegion = ti2.texRegion;
                }
                s.x = x;
                s.y = y;
                s.billboard = true;
                sl.addSymbol(s);
            }
        }
        l = this.mPool.release(l);
        work.textLayer.labels = this.groupLabels(this.mLabels);
        work.textLayer.prepare();
        work.textLayer.labels = null;
        this.mTileRenderer.releaseTiles(this.mTileSet);
        return true;
    }

    public void cleanup() {
        this.mLabels = this.mPool.releaseAll(this.mLabels);
        this.mTileSet.releaseTiles();
    }

    protected Label groupLabels(Label labels) {
        Label cur = labels;
        while (cur != null) {
            Label p = cur;
            TextStyle t = cur.text;
            float w = cur.width;
            Label l = (Label)cur.next;
            while (l != null) {
                if (w != l.width || t != l.text || !cur.label.equals(l.label)) {
                    p = l;
                } else if (cur.next == l) {
                    l.label = cur.label;
                    p = l;
                } else {
                    l.label = cur.label;
                    Label tmp = (Label)cur.next;
                    cur.next = l;
                    cur = l;
                    p.next = l.next;
                    l.next = tmp;
                    l = p;
                }
                l = (Label)l.next;
            }
            cur = (Label)cur.next;
        }
        return labels;
    }
}

