/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.IntBuffer;
import org.oscim.backend.AssetAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.MapRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GLShader {
    static final Logger log = LoggerFactory.getLogger(GLShader.class);
    public int program;

    protected boolean create(String vertexSource, String fragmentSource) {
        return this.createVersioned(vertexSource, fragmentSource, null);
    }

    protected boolean createVersioned(String vertexSource, String fragmentSource, String version) {
        this.program = GLShader.createProgramVersioned(vertexSource, fragmentSource, version);
        return this.program != 0;
    }

    protected boolean create(String fileName) {
        return this.createVersioned(fileName, null);
    }

    protected boolean createVersioned(String fileName, String version) {
        this.program = GLShader.loadShaderVersioned(fileName, version);
        return this.program != 0;
    }

    protected int getAttrib(String name) {
        int loc = GLAdapter.gl.getAttribLocation(this.program, name);
        if (loc < 0) {
            log.debug("missing attribute: {}", (Object)name);
        }
        return loc;
    }

    protected int getUniform(String name) {
        int loc = GLAdapter.gl.getUniformLocation(this.program, name);
        if (loc < 0) {
            log.debug("missing uniform: {}", (Object)name);
        }
        return loc;
    }

    public boolean useProgram() {
        return GLState.useProgram(this.program);
    }

    public static int loadShader(String file) {
        return GLShader.loadShaderVersioned(file, null);
    }

    public static int loadShaderVersioned(String file, String version) {
        String path = "shaders/" + file + ".glsl";
        String vs = AssetAdapter.readTextFile(path);
        if (vs == null) {
            throw new IllegalArgumentException("shader file not found: " + path);
        }
        int fsStart = vs.indexOf(36);
        if (fsStart < 0 || vs.charAt(fsStart + 1) != '$') {
            throw new IllegalArgumentException("not a shader file " + path);
        }
        String fs = vs.substring(fsStart + 2);
        int shader = GLShader.createProgramVersioned(vs = vs.substring(0, fsStart), fs, version);
        if (shader == 0) {
            System.out.println(vs + " \n\n" + fs);
        }
        return shader;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLAdapter.gl.createShader(shaderType);
        if (shader != 0) {
            GLAdapter.gl.shaderSource(shader, source);
            GLAdapter.gl.compileShader(shader);
            IntBuffer compiled = MapRenderer.getIntBuffer(1);
            GLAdapter.gl.getShaderiv(shader, 35713, compiled);
            compiled.position(0);
            if (compiled.get() == 0) {
                log.error("Could not compile shader " + shaderType + ":");
                log.error(GLAdapter.gl.getShaderInfoLog(shader));
                GLAdapter.gl.deleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    public static int createProgram(String vertexSource, String fragmentSource) {
        return GLShader.createProgramVersioned(vertexSource, fragmentSource, null);
    }

    public static int createProgramVersioned(String vertexSource, String fragmentSource, String version) {
        int vertexShader;
        String defs = "";
        if (version != null) {
            defs = defs + "#version " + version + "\n";
        }
        if ((vertexShader = GLShader.loadShader(35633, (defs = GLAdapter.GDX_DESKTOP_QUIRKS ? defs + "#define DESKTOP_QUIRKS 1\n" : defs + "#define GLES 1\n") + vertexSource)) == 0) {
            return 0;
        }
        int pixelShader = GLShader.loadShader(35632, defs + fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLAdapter.gl.createProgram();
        if (program != 0) {
            GLUtils.checkGlError("glCreateProgram");
            GLAdapter.gl.attachShader(program, vertexShader);
            GLUtils.checkGlError("glAttachShader");
            GLAdapter.gl.attachShader(program, pixelShader);
            GLUtils.checkGlError("glAttachShader");
            GLAdapter.gl.linkProgram(program);
            IntBuffer linkStatus = MapRenderer.getIntBuffer(1);
            GLAdapter.gl.getProgramiv(program, 35714, linkStatus);
            linkStatus.position(0);
            if (linkStatus.get() != 1) {
                log.error("Could not link program: ");
                log.error(GLAdapter.gl.getProgramInfoLog(program));
                GLAdapter.gl.deleteProgram(program);
                program = 0;
            }
        }
        return program;
    }
}

