/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;

public class BitmapBucket
extends TextureBucket {
    private Bitmap mBitmap;
    private final boolean mReuseBitmap;
    private final short[] mVertices;
    private int mWidth;
    private int mHeight;

    public BitmapBucket(boolean reuseBitmap) {
        super((byte)7);
        this.mReuseBitmap = reuseBitmap;
        this.mVertices = new short[24];
        this.numVertices = 4;
    }

    public void setBitmap(Bitmap bitmap, int w, int h) {
        this.setBitmap(bitmap, w, h, null);
    }

    public void setBitmap(Bitmap bitmap, int w, int h, TextureItem.TexturePool pool) {
        this.mWidth = w;
        this.mHeight = h;
        this.mBitmap = bitmap;
        if (this.textures == null) {
            this.textures = pool == null ? new TextureItem(this.mBitmap) : pool.get(this.mBitmap);
        }
        TextureItem t = this.textures;
        t.indices = 6;
    }

    private void setVertices(ShortBuffer vboData) {
        short[] buf = this.mVertices;
        short w = (short)((float)this.mWidth * MapRenderer.COORD_SCALE);
        short h = (short)((float)this.mHeight * MapRenderer.COORD_SCALE);
        short texMin = 0;
        short texMax = 1;
        int pos = 0;
        buf[pos++] = 0;
        buf[pos++] = 0;
        buf[pos++] = -1;
        buf[pos++] = -1;
        buf[pos++] = texMin;
        buf[pos++] = texMin;
        buf[pos++] = 0;
        buf[pos++] = h;
        buf[pos++] = -1;
        buf[pos++] = -1;
        buf[pos++] = texMin;
        buf[pos++] = texMax;
        buf[pos++] = w;
        buf[pos++] = 0;
        buf[pos++] = -1;
        buf[pos++] = -1;
        buf[pos++] = texMax;
        buf[pos++] = texMin;
        buf[pos++] = w;
        buf[pos++] = h;
        buf[pos++] = -1;
        buf[pos++] = -1;
        buf[pos++] = texMax;
        buf[pos++] = texMax;
        this.vertexOffset = vboData.position() * 2;
        vboData.put(buf);
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        if (this.mBitmap == null) {
            return;
        }
        this.setVertices(vboData);
        this.textures.upload();
        if (!this.mReuseBitmap) {
            this.mBitmap.recycle();
            this.mBitmap = null;
            this.textures.bitmap = null;
        }
    }

    @Override
    protected void clear() {
        super.clear();
        if (this.mBitmap == null) {
            return;
        }
        if (!this.mReuseBitmap) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
    }

    public static final class Renderer {
        public static final int INDICES_PER_SPRITE = 6;
        static final int VERTICES_PER_SPRITE = 4;
        static final int SHORTS_PER_VERTICE = 6;
        static Shader shader;

        static void init() {
            shader = new Shader("texture_alpha");
        }

        public static RenderBucket draw(RenderBucket b, GLViewport v, float scale, float alpha) {
            GLState.blend(true);
            Shader s = shader;
            s.useProgram();
            TextureBucket tb = (TextureBucket)b;
            GLAdapter.gl.uniform1f(s.uAlpha, alpha);
            v.mvp.setAsUniform(s.uMVP);
            MapRenderer.bindQuadIndicesVBO();
            TextureItem t = tb.textures;
            while (t != null) {
                t.bind();
                for (int i = 0; i < t.indices; i += 3072) {
                    int off = (t.offset + i) * 8 + tb.vertexOffset;
                    GLAdapter.gl.vertexAttribPointer(s.aPos, 2, 5122, false, 12, off);
                    GLAdapter.gl.vertexAttribPointer(s.aTexCoord, 2, 5122, false, 12, off + 8);
                    int numIndices = t.indices - i;
                    if (numIndices > 3072) {
                        numIndices = 3072;
                    }
                    GLAdapter.gl.drawElements(4, numIndices, 5123, 0);
                }
                t = (TextureItem)t.next;
            }
            return (RenderBucket)b.next;
        }
    }

    static class Shader
    extends GLShader {
        int uMVP;
        int uAlpha;
        int aPos;
        int aTexCoord;

        Shader(String shaderFile) {
            if (!this.create(shaderFile)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uAlpha = this.getUniform("u_alpha");
            this.aPos = this.getAttrib("vertex");
            this.aTexCoord = this.getAttrib("tex_coord");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, this.aTexCoord);
                return true;
            }
            return false;
        }
    }
}

