/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.core.GeometryBuffer;
import org.oscim.layers.tile.MapTile;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrusionBuckets
extends MapTile.TileData {
    static final Logger log = LoggerFactory.getLogger(ExtrusionBuckets.class);
    public ExtrusionBucket buckets;
    public boolean compiled;
    public long animTime;
    public final int zoomLevel;
    public final double x;
    public final double y;
    public BufferObject ibo;
    public BufferObject vbo;

    public ExtrusionBuckets(MapTile tile) {
        this.zoomLevel = tile.zoomLevel;
        this.x = tile.x;
        this.y = tile.y;
    }

    public void addMeshElement(GeometryBuffer element, float groundScale, int color) {
        ExtrusionBucket eb;
        for (eb = this.buckets; eb != null; eb = eb.next()) {
            if (eb.getColor() != color) continue;
            eb.addMesh(element);
            return;
        }
        eb = new ExtrusionBucket(0, groundScale, color);
        this.buckets = Inlist.push(this.buckets, eb);
        this.buckets.addMesh(element);
    }

    public void addPolyElement(GeometryBuffer element, float groundScale, float[] colors, int height, int minHeight) {
        ExtrusionBucket eb;
        for (eb = this.buckets; eb != null; eb = eb.next()) {
            if (eb.getColors() != colors) continue;
            eb.addPoly(element, height, minHeight);
            return;
        }
        eb = new ExtrusionBucket(0, groundScale, colors);
        this.buckets = Inlist.push(this.buckets, eb);
        this.buckets.addPoly(element, height, minHeight);
    }

    public void resetBuckets(ExtrusionBucket el) {
        RenderBucket b = this.buckets;
        while (b != null) {
            ((RenderBucket)b).clear();
            b = (RenderBucket)b.next;
        }
        this.buckets = el;
    }

    public ExtrusionBucket buckets() {
        return this.buckets;
    }

    @Override
    protected void dispose() {
        this.resetBuckets(null);
        if (this.compiled) {
            this.ibo = BufferObject.release(this.ibo);
            this.vbo = BufferObject.release(this.vbo);
        }
    }

    public void prepare() {
        RenderBucket b = this.buckets;
        while (b != null) {
            ((RenderBucket)b).prepare();
            b = (RenderBucket)b.next;
        }
    }

    public boolean compile() {
        int pos;
        if (this.buckets == null) {
            return false;
        }
        int sumIndices = 0;
        int sumVertices = 0;
        for (ExtrusionBucket b = this.buckets; b != null; b = b.next()) {
            sumIndices += b.numIndices;
            sumVertices += b.numVertices;
        }
        if (sumIndices == 0) {
            return false;
        }
        ShortBuffer vboData = MapRenderer.getShortBuffer(sumVertices * 4);
        ShortBuffer iboData = MapRenderer.getShortBuffer(sumIndices);
        for (ExtrusionBucket b = this.buckets; b != null; b = b.next()) {
            b.compile(vboData, iboData);
        }
        int size = sumIndices * 2;
        if (iboData.position() != sumIndices) {
            pos = iboData.position();
            log.error("invalid indice size: {} {}", (Object)sumIndices, (Object)pos);
            size = pos * 2;
        }
        this.ibo = BufferObject.get(34963, size);
        this.ibo.loadBufferData(iboData.flip(), size);
        size = sumVertices * 4 * 2;
        if (vboData.position() != sumVertices * 4) {
            pos = vboData.position();
            log.error("invalid vertex size: {} {}", (Object)sumVertices, (Object)pos);
            size = pos * 2;
        }
        this.vbo = BufferObject.get(34962, size);
        this.vbo.loadBufferData(vboData.flip(), size);
        this.compiled = true;
        return true;
    }
}

