/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.ArrayList;
import java.util.Arrays;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.TagSet;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.MatchingCacheKey;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderTheme
implements IRenderTheme {
    static final Logger log = LoggerFactory.getLogger(RenderTheme.class);
    private static final int MATCHING_CACHE_SIZE = 512;
    private final float mBaseTextSize;
    private final int mMapBackground;
    private final int mLevels;
    private final Rule[] mRules;
    private final boolean mMapsforgeTheme;
    private final RenderStyleCache[] mStyleCache;

    public RenderTheme(int mapBackground, float baseTextSize, Rule[] rules, int levels) {
        this(mapBackground, baseTextSize, rules, levels, false);
    }

    public RenderTheme(int mapBackground, float baseTextSize, Rule[] rules, int levels, boolean mapsforgeTheme) {
        if (rules == null) {
            throw new IllegalArgumentException("rules missing");
        }
        this.mMapBackground = mapBackground;
        this.mBaseTextSize = baseTextSize;
        this.mLevels = levels;
        this.mRules = rules;
        this.mMapsforgeTheme = mapsforgeTheme;
        this.mStyleCache = new RenderStyleCache[3];
        this.mStyleCache[0] = new RenderStyleCache(1);
        this.mStyleCache[1] = new RenderStyleCache(2);
        this.mStyleCache[2] = new RenderStyleCache(4);
    }

    @Override
    public void dispose() {
        for (int i = 0; i < 3; ++i) {
            this.mStyleCache[i].cache.clear();
        }
        for (Rule rule : this.mRules) {
            rule.dispose();
        }
    }

    @Override
    public int getLevels() {
        return this.mLevels;
    }

    @Override
    public int getMapBackground() {
        return this.mMapBackground;
    }

    Rule[] getRules() {
        return this.mRules;
    }

    @Override
    public boolean isMapsforgeTheme() {
        return this.mMapsforgeTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenderStyle[] matchElement(GeometryBuffer.GeometryType geometryType, TagSet tags, int zoomLevel) {
        RenderStyleItem ris = null;
        RenderStyleItem ri = null;
        int type = geometryType.nativeInt;
        if (type < 1 || type > 3) {
            log.debug("invalid geometry type for RenderTheme " + geometryType.name());
            return null;
        }
        RenderStyleCache cache = this.mStyleCache[type - 1];
        int zoomMask = 1 << zoomLevel;
        RenderStyleCache renderStyleCache = cache;
        synchronized (renderStyleCache) {
            if (cache.prevItem == null || (cache.prevItem.zoom & zoomMask) == 0) {
                cache.cacheKey.set(tags, null);
            } else if (cache.cacheKey.set(tags, cache.prevItem.key)) {
                ri = cache.prevItem;
            }
            if (ri == null) {
                ri = ris = cache.getRenderInstructions();
                while (ri != null && (ri.zoom & zoomMask) == 0) {
                    ri = ri.next;
                }
            }
            if (ri == null) {
                int i;
                ArrayList<RenderStyle> matches = cache.instructionList;
                matches.clear();
                for (Rule rule : this.mRules) {
                    rule.matchElement(cache.matchType, cache.cacheKey.mTags, zoomMask, matches);
                }
                int size = matches.size();
                if (size > 1) {
                    for (i = 0; i < size - 1; ++i) {
                        RenderStyle r = (RenderStyle)matches.get(i);
                        for (int j = i + 1; j < size; ++j) {
                            if (matches.get(j) != r) continue;
                            log.debug("fix duplicate instruction! " + Arrays.deepToString(cache.cacheKey.mTags) + " zoom:" + zoomLevel + " " + r.getClass().getName());
                            matches.remove(j--);
                            --size;
                        }
                    }
                }
                ri = ris;
                while (ri != null) {
                    if (size == 0) {
                        if (ri.list == null) break;
                    } else if (ri.list != null && ri.list.length == size) {
                        i = 0;
                        for (RenderStyle r : ri.list) {
                            if (r != matches.get(i)) break;
                            ++i;
                        }
                        if (i == size) break;
                    }
                    ri = ri.next;
                }
                if (ri != null) {
                    ri.zoom |= zoomMask;
                } else {
                    ri = new RenderStyleItem();
                    ri.zoom = zoomMask;
                    if (size > 0) {
                        ri.list = new RenderStyle[size];
                        matches.toArray(ri.list);
                    }
                    if (ris != null) {
                        ri.next = ris.next;
                        ri.key = ris.key;
                        ris.next = ri;
                    } else {
                        ri.key = new MatchingCacheKey(cache.cacheKey);
                        cache.cache.put(ri.key, ri);
                    }
                }
            }
            cache.prevItem = ri;
        }
        return ri.list;
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
        for (Rule rule : this.mRules) {
            rule.scaleTextSize(scaleFactor * this.mBaseTextSize);
        }
    }

    @Override
    public void updateStyles() {
        for (Rule rule : this.mRules) {
            rule.updateStyles();
        }
    }

    public void traverseRules(Rule.RuleVisitor visitor) {
        for (Rule rule : this.mRules) {
            rule.apply(visitor);
        }
    }

    class RenderStyleItem {
        RenderStyleItem next;
        int zoom;
        RenderStyle[] list;
        MatchingCacheKey key;

        RenderStyleItem() {
        }
    }

    class RenderStyleCache {
        final int matchType;
        final LRUCache<MatchingCacheKey, RenderStyleItem> cache = new LRUCache(512);
        final MatchingCacheKey cacheKey;
        final ArrayList<RenderStyle> instructionList = new ArrayList(4);
        RenderStyleItem prevItem;

        public RenderStyleCache(int type) {
            this.cacheKey = new MatchingCacheKey();
            this.matchType = type;
        }

        RenderStyleItem getRenderInstructions() {
            return (RenderStyleItem)this.cache.get(this.cacheKey);
        }
    }
}

