/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.concurrent.atomic.AtomicBoolean;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.theme.SAXTerminationException;
import org.oscim.theme.ThemeFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ThemeUtils {
    private static final Logger log = LoggerFactory.getLogger(ThemeUtils.class);

    public static boolean isMapsforgeTheme(ThemeFile theme) {
        try {
            final AtomicBoolean isMapsforgeTheme = new AtomicBoolean(false);
            try {
                new XMLReaderAdapter().parse(new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (localName.equals("rendertheme")) {
                            isMapsforgeTheme.set(uri.equals("http://mapsforge.org/renderTheme"));
                            throw new SAXTerminationException();
                        }
                    }
                }, theme.getRenderThemeAsStream());
            }
            catch (SAXTerminationException sAXTerminationException) {
                // empty catch block
            }
            return isMapsforgeTheme.get();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private ThemeUtils() {
    }
}

