/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.theme.styles.RenderStyle;

public final class CircleStyle
extends RenderStyle<CircleStyle> {
    public final int fillColor;
    private final int level;
    public final float radius;
    public final boolean scaleRadius;
    public final int strokeColor;
    public final float strokeWidth;

    public CircleStyle(float radius, boolean scaleRadius, int fillColor, int strokeColor, float strokeWidth, int level) {
        this.radius = radius;
        this.scaleRadius = scaleRadius;
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.level = level;
    }

    public CircleStyle(CircleBuilder<?> b) {
        this.cat = b.cat;
        this.radius = b.radius;
        this.scaleRadius = b.scaleRadius;
        this.fillColor = b.themeCallback != null ? b.themeCallback.getColor(b.fillColor) : b.fillColor;
        this.strokeColor = b.themeCallback != null ? b.themeCallback.getColor(b.strokeColor) : b.strokeColor;
        this.strokeWidth = b.strokeWidth;
        this.level = b.level;
    }

    @Override
    public CircleStyle current() {
        return (CircleStyle)this.mCurrent;
    }

    @Override
    public void renderNode(RenderStyle.Callback cb) {
        cb.renderCircle(this, this.level);
    }

    public static CircleBuilder<?> builder() {
        return new CircleBuilder();
    }

    public static class CircleBuilder<T extends CircleBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float radius;
        public boolean scaleRadius;

        public T set(CircleStyle circle) {
            if (circle == null) {
                return this.reset();
            }
            this.radius = circle.radius;
            this.scaleRadius = circle.scaleRadius;
            this.fillColor = this.themeCallback != null ? this.themeCallback.getColor(circle.fillColor) : circle.fillColor;
            this.strokeColor = this.themeCallback != null ? this.themeCallback.getColor(circle.strokeColor) : circle.strokeColor;
            this.strokeWidth = circle.strokeWidth;
            this.cat = circle.cat;
            this.level = circle.level;
            return (T)((CircleBuilder)this.self());
        }

        public T radius(float radius) {
            this.radius = radius;
            return (T)((CircleBuilder)this.self());
        }

        public T scaleRadius(boolean scaleRadius) {
            this.scaleRadius = scaleRadius;
            return (T)((CircleBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.radius = 0.0f;
            this.scaleRadius = false;
            this.fillColor = 0;
            this.strokeColor = 0;
            this.strokeWidth = 0.0f;
            return (T)((CircleBuilder)this.self());
        }

        @Override
        public CircleStyle build() {
            return new CircleStyle(this);
        }
    }
}

