/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.theme.styles.RenderStyle;

public class ExtrusionStyle
extends RenderStyle<ExtrusionStyle> {
    public final int colorLine;
    public final int colorSide;
    public final int colorTop;
    public final int defaultHeight;
    private final int level;
    public final float[] colors;

    public ExtrusionStyle(int level, int colorSide, int colorTop, int colorLine, int defaultHeight) {
        this.level = level;
        this.colorSide = colorSide;
        this.colorTop = colorTop;
        this.colorLine = colorLine;
        this.colors = new float[16];
        ExtrusionStyle.fillColors(colorSide, colorTop, colorLine, this.colors);
        this.defaultHeight = defaultHeight;
    }

    public ExtrusionStyle(ExtrusionBuilder<?> b) {
        this.cat = b.cat;
        this.level = b.level;
        this.colorSide = b.themeCallback != null ? b.themeCallback.getColor(b.colorSide) : b.colorSide;
        this.colorTop = b.themeCallback != null ? b.themeCallback.getColor(b.colorTop) : b.colorTop;
        this.colorLine = b.themeCallback != null ? b.themeCallback.getColor(b.colorLine) : b.colorLine;
        this.colors = new float[16];
        ExtrusionStyle.fillColors(this.colorSide, this.colorTop, this.colorLine, this.colors);
        this.defaultHeight = b.defaultHeight;
    }

    public static void fillColors(int side, int top, int line, float[] colors) {
        float a = Color.aToFloat(top);
        colors[0] = a * Color.rToFloat(top);
        colors[1] = a * Color.gToFloat(top);
        colors[2] = a * Color.bToFloat(top);
        colors[3] = a;
        a = Color.aToFloat(side);
        colors[4] = a * Color.rToFloat(side);
        colors[5] = a * Color.gToFloat(side);
        colors[6] = a * Color.bToFloat(side);
        colors[7] = a;
        a = Color.aToFloat(side);
        colors[8] = a * Color.rToFloat(side);
        colors[9] = a * Color.gToFloat(side);
        colors[10] = a * Color.bToFloat(side);
        colors[11] = a;
        a = Color.aToFloat(line);
        colors[12] = a * Color.rToFloat(line);
        colors[13] = a * Color.gToFloat(line);
        colors[14] = a * Color.bToFloat(line);
        colors[15] = a;
    }

    @Override
    public ExtrusionStyle current() {
        return (ExtrusionStyle)this.mCurrent;
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderExtrusion(this, this.level);
    }

    public static ExtrusionBuilder<?> builder() {
        return new ExtrusionBuilder();
    }

    public static class ExtrusionBuilder<T extends ExtrusionBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public int colorSide;
        public int colorTop;
        public int colorLine;
        public int defaultHeight;

        public T set(ExtrusionStyle extrusion) {
            if (extrusion == null) {
                return this.reset();
            }
            this.cat = extrusion.cat;
            this.level = extrusion.level;
            this.colorSide = this.themeCallback != null ? this.themeCallback.getColor(extrusion.colorSide) : extrusion.colorSide;
            this.colorTop = this.themeCallback != null ? this.themeCallback.getColor(extrusion.colorTop) : extrusion.colorTop;
            this.colorLine = this.themeCallback != null ? this.themeCallback.getColor(extrusion.colorLine) : extrusion.colorLine;
            this.defaultHeight = extrusion.defaultHeight;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorSide(int colorSide) {
            this.colorSide = colorSide;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorSide(String colorSide) {
            this.colorSide = Color.parseColor(colorSide);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorTop(int colorTop) {
            this.colorTop = colorTop;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorTop(String colorTop) {
            this.colorTop = Color.parseColor(colorTop);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorLine(int colorLine) {
            this.colorLine = colorLine;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorLine(String colorLine) {
            this.colorLine = Color.parseColor(colorLine);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T defaultHeight(int defaultHeight) {
            this.defaultHeight = defaultHeight;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.colorSide = 0;
            this.colorTop = 0;
            this.colorLine = 0;
            this.defaultHeight = 12;
            return (T)((ExtrusionBuilder)this.self());
        }

        @Override
        public ExtrusionStyle build() {
            return new ExtrusionStyle(this);
        }
    }
}

