/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.styles.RenderStyle;

public final class SymbolStyle
extends RenderStyle<SymbolStyle> {
    public final Bitmap bitmap;
    public final TextureRegion texture;
    public final int hash;
    public final int symbolWidth;
    public final int symbolHeight;
    public final int symbolPercent;

    public SymbolStyle(Bitmap bitmap) {
        this(bitmap, null, 0);
    }

    public SymbolStyle(TextureRegion texture) {
        this(null, texture, 0);
    }

    public SymbolStyle(int hash) {
        this(null, null, hash);
    }

    private SymbolStyle(Bitmap bitmap, TextureRegion texture, int hash) {
        this.bitmap = bitmap;
        this.texture = texture;
        this.hash = hash;
        this.symbolWidth = 0;
        this.symbolHeight = 0;
        this.symbolPercent = 100;
    }

    public SymbolStyle(SymbolBuilder<?> b) {
        this.cat = b.cat;
        this.bitmap = b.bitmap;
        this.texture = b.texture;
        this.hash = b.hash;
        this.symbolWidth = b.symbolWidth;
        this.symbolHeight = b.symbolHeight;
        this.symbolPercent = b.symbolPercent;
    }

    @Override
    public SymbolStyle current() {
        return (SymbolStyle)this.mCurrent;
    }

    @Override
    public void dispose() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    @Override
    public void renderNode(RenderStyle.Callback cb) {
        cb.renderSymbol(this);
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderSymbol(this);
    }

    public static SymbolBuilder<?> builder() {
        return new SymbolBuilder();
    }

    public static class SymbolBuilder<T extends SymbolBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public Bitmap bitmap;
        public TextureRegion texture;
        public int hash;
        public int symbolWidth;
        public int symbolHeight;
        public int symbolPercent;

        public T set(SymbolStyle symbol) {
            if (symbol == null) {
                return this.reset();
            }
            this.cat = symbol.cat;
            this.bitmap = symbol.bitmap;
            this.texture = symbol.texture;
            this.hash = symbol.hash;
            this.symbolWidth = symbol.symbolWidth;
            this.symbolHeight = symbol.symbolHeight;
            this.symbolPercent = symbol.symbolPercent;
            return (T)((SymbolBuilder)this.self());
        }

        public T bitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return (T)((SymbolBuilder)this.self());
        }

        public T texture(TextureRegion texture) {
            this.texture = texture;
            return (T)((SymbolBuilder)this.self());
        }

        public T hash(int hash) {
            this.hash = hash;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolWidth(int symbolWidth) {
            this.symbolWidth = symbolWidth;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolHeight(int symbolHeight) {
            this.symbolHeight = symbolHeight;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolPercent(int symbolPercent) {
            this.symbolPercent = symbolPercent;
            return (T)((SymbolBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.bitmap = null;
            this.texture = null;
            this.hash = 0;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            return (T)((SymbolBuilder)this.self());
        }

        @Override
        public SymbolStyle build() {
            return new SymbolStyle(this);
        }
    }
}

