/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import java.io.IOException;
import org.oscim.core.BoundingBox;
import org.oscim.core.Tag;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;

final class RequiredFields {
    private static final String BINARY_OSM_MAGIC_BYTE = "mapsforge binary OSM";
    private static final int HEADER_SIZE_MAX = 1000000;
    private static final int HEADER_SIZE_MIN = 70;
    private static final String MERCATOR = "Mercator";
    private static final char SPACE = ' ';
    private static final int SUPPORTED_FILE_VERSION_MIN = 3;
    private static final int SUPPORTED_FILE_VERSION_MAX = 5;
    static final int LATITUDE_MAX = 90000000;
    static final int LATITUDE_MIN = -90000000;
    static final int LONGITUDE_MAX = 180000000;
    static final int LONGITUDE_MIN = -180000000;

    static TileSource.OpenResult readBoundingBox(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int minLatitude = readBuffer.readInt();
        if (minLatitude < -90000000 || minLatitude > 90000000) {
            return new TileSource.OpenResult("invalid minimum latitude: " + minLatitude);
        }
        int minLongitude = readBuffer.readInt();
        if (minLongitude < -180000000 || minLongitude > 180000000) {
            return new TileSource.OpenResult("invalid minimum longitude: " + minLongitude);
        }
        int maxLatitude = readBuffer.readInt();
        if (maxLatitude < -90000000 || maxLatitude > 90000000) {
            return new TileSource.OpenResult("invalid maximum latitude: " + maxLatitude);
        }
        int maxLongitude = readBuffer.readInt();
        if (maxLongitude < -180000000 || maxLongitude > 180000000) {
            return new TileSource.OpenResult("invalid maximum longitude: " + maxLongitude);
        }
        if (minLatitude > maxLatitude) {
            return new TileSource.OpenResult("invalid latitude range: " + minLatitude + ' ' + maxLatitude);
        }
        if (minLongitude > maxLongitude) {
            return new TileSource.OpenResult("invalid longitude range: " + minLongitude + ' ' + maxLongitude);
        }
        mapFileInfoBuilder.boundingBox = new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readFileSize(ReadBuffer readBuffer, long fileSize, MapFileInfoBuilder mapFileInfoBuilder) {
        long headerFileSize = readBuffer.readLong();
        if (headerFileSize != fileSize) {
            return new TileSource.OpenResult("invalid file size: " + headerFileSize);
        }
        mapFileInfoBuilder.fileSize = fileSize;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readFileVersion(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int fileVersion = readBuffer.readInt();
        if (fileVersion < 3 || fileVersion > 5) {
            return new TileSource.OpenResult("unsupported file version: " + fileVersion);
        }
        mapFileInfoBuilder.fileVersion = fileVersion;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readMagicByte(ReadBuffer readBuffer) throws IOException {
        int magicByteLength = BINARY_OSM_MAGIC_BYTE.length();
        if (!readBuffer.readFromFile(magicByteLength + 4)) {
            return new TileSource.OpenResult("reading magic byte has failed");
        }
        String magicByte = readBuffer.readUTF8EncodedString(magicByteLength);
        if (!BINARY_OSM_MAGIC_BYTE.equals(magicByte)) {
            return new TileSource.OpenResult("invalid magic byte: " + magicByte);
        }
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readMapDate(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        long mapDate = readBuffer.readLong();
        if (mapDate < 1200000000000L) {
            return new TileSource.OpenResult("invalid map date: " + mapDate);
        }
        mapFileInfoBuilder.mapDate = mapDate;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readPoiTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfPoiTags = readBuffer.readShort();
        if (numberOfPoiTags < 0) {
            return new TileSource.OpenResult("invalid number of POI tags: " + numberOfPoiTags);
        }
        Tag[] poiTags = new Tag[numberOfPoiTags];
        for (int currentTagId = 0; currentTagId < numberOfPoiTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                return new TileSource.OpenResult("POI tag must not be null: " + currentTagId);
            }
            poiTags[currentTagId] = Tag.parse(tag);
        }
        mapFileInfoBuilder.poiTags = poiTags;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readProjectionName(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        String projectionName = readBuffer.readUTF8EncodedString();
        if (!MERCATOR.equals(projectionName)) {
            return new TileSource.OpenResult("unsupported projection: " + projectionName);
        }
        mapFileInfoBuilder.projectionName = projectionName;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readRemainingHeader(ReadBuffer readBuffer) throws IOException {
        int remainingHeaderSize = readBuffer.readInt();
        if (remainingHeaderSize < 70 || remainingHeaderSize > 1000000) {
            return new TileSource.OpenResult("invalid remaining header size: " + remainingHeaderSize);
        }
        if (!readBuffer.readFromFile(remainingHeaderSize)) {
            return new TileSource.OpenResult("reading header data has failed: " + remainingHeaderSize);
        }
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readTilePixelSize(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int tilePixelSize;
        mapFileInfoBuilder.tilePixelSize = tilePixelSize = readBuffer.readShort();
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readWayTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfWayTags = readBuffer.readShort();
        if (numberOfWayTags < 0) {
            return new TileSource.OpenResult("invalid number of way tags: " + numberOfWayTags);
        }
        Tag[] wayTags = new Tag[numberOfWayTags];
        for (int currentTagId = 0; currentTagId < numberOfWayTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                return new TileSource.OpenResult("way tag must not be null: " + currentTagId);
            }
            wayTags[currentTagId] = Tag.parse(tag);
        }
        mapFileInfoBuilder.wayTags = wayTags;
        return TileSource.OpenResult.SUCCESS;
    }

    private RequiredFields() {
        throw new IllegalStateException();
    }
}

