/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.oscimap4;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.tiling.source.oscimap4.Tags;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDecoder
extends PbfDecoder {
    static final Logger log = LoggerFactory.getLogger(TileDecoder.class);
    private static final int TAG_TILE_VERSION = 1;
    private static final int TAG_TILE_NUM_TAGS = 11;
    private static final int TAG_TILE_NUM_KEYS = 12;
    private static final int TAG_TILE_NUM_VALUES = 13;
    private static final int TAG_TILE_TAG_KEYS = 14;
    private static final int TAG_TILE_TAG_VALUES = 15;
    private static final int TAG_TILE_TAGS = 16;
    private static final int TAG_TILE_LINE = 21;
    private static final int TAG_TILE_POLY = 22;
    private static final int TAG_TILE_POINT = 23;
    private static final int TAG_TILE_MESH = 24;
    private static final int TAG_ELEM_NUM_INDICES = 1;
    private static final int TAG_ELEM_NUM_TAGS = 2;
    private static final int TAG_ELEM_NUM_COORDINATES = 3;
    private static final int TAG_ELEM_TAGS = 11;
    private static final int TAG_ELEM_INDEX = 12;
    private static final int TAG_ELEM_COORDS = 13;
    private static final int TAG_ELEM_LAYER = 21;
    private int[] mSArray = new int[100];
    private Tile mTile;
    private final MapElement mElem;
    private final TagSet mTileTags;
    private ITileDataSink mMapDataSink;
    private int mVersion;
    private static final float REF_TILE_SIZE = 4096.0f;
    private final float mScaleFactor = 4096.0f / (float)Tile.SIZE;

    public TileDecoder() {
        this.mElem = new MapElement();
        this.mTileTags = new TagSet(100);
    }

    @Override
    public boolean decode(Tile tile, ITileDataSink sink, InputStream is) throws IOException {
        int val;
        TileDecoder.readUnsignedInt(is, this.buffer);
        this.setInputStream(is);
        this.mTile = tile;
        this.mMapDataSink = sink;
        this.mTileTags.clearAndNullTags();
        int numTags = 0;
        int numKeys = -1;
        int numValues = -1;
        int curKey = 0;
        int curValue = 0;
        String[] keys = null;
        String[] values = null;
        block10: while (this.hasData() && (val = this.decodeVarint32()) > 0) {
            int tag = val >> 3;
            switch (tag) {
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.decodeTileElement(tag);
                    continue block10;
                }
                case 14: {
                    if (keys == null || curKey >= numKeys) {
                        log.debug("{} wrong number of keys {}", (Object)this.mTile, (Object)numKeys);
                        return false;
                    }
                    keys[curKey++] = this.decodeString().intern();
                    continue block10;
                }
                case 15: {
                    if (values == null || curValue >= numValues) {
                        log.debug("{} wrong number of values {}", (Object)this.mTile, (Object)numValues);
                        return false;
                    }
                    values[curValue++] = this.decodeString();
                    continue block10;
                }
                case 11: {
                    numTags = this.decodeVarint32();
                    continue block10;
                }
                case 12: {
                    numKeys = this.decodeVarint32();
                    keys = new String[numKeys];
                    continue block10;
                }
                case 13: {
                    numValues = this.decodeVarint32();
                    values = new String[numValues];
                    continue block10;
                }
                case 16: {
                    int len = numTags * 2;
                    if (this.mSArray.length < len) {
                        this.mSArray = new int[len];
                    }
                    this.decodeVarintArray(len, this.mSArray);
                    if (this.decodeTileTags(numTags, this.mSArray, keys, values)) continue block10;
                    log.debug("{} invalid tags", (Object)this.mTile);
                    return false;
                }
                case 1: {
                    int version = this.decodeVarint32();
                    if (version >= 4 && this.mVersion <= 5) continue block10;
                    log.debug("{} invalid version:{}", (Object)this.mTile, (Object)version);
                    return false;
                }
            }
            log.debug("{} invalid type for tile:{}", (Object)this.mTile, (Object)tag);
            return false;
        }
        return true;
    }

    private boolean decodeTileTags(int numTags, int[] tagIdx, String[] keys, String[] vals) {
        int n = numTags << 1;
        for (int i = 0; i < n; i += 2) {
            String val;
            String key;
            int k = tagIdx[i];
            int v = tagIdx[i + 1];
            if (k < 256) {
                if (k > Tags.MAX_KEY) {
                    return false;
                }
                key = Tags.keys[k];
            } else {
                if ((k -= 256) >= keys.length) {
                    return false;
                }
                key = keys[k];
            }
            if (v < 256) {
                if (v > Tags.MAX_VALUE) {
                    return false;
                }
                val = Tags.values[v];
            } else {
                if ((v -= 256) >= vals.length) {
                    return false;
                }
                val = vals[v];
            }
            Tag tag = "name".equals(key) || "addr:housenumber".equals(key) || "ref".equals(key) || "ele".equals(key) ? new Tag(key, val, false) : ("height".equals(key) || "min_height".equals(key) ? new Tag(key, String.valueOf(MathUtils.round2(Float.valueOf(val).floatValue() / 100.0f)), false) : new Tag(key, val, false, true));
            this.mTileTags.add(tag);
        }
        return true;
    }

    private int decodeWayIndices(int indexCnt, boolean shift) throws IOException {
        this.mElem.ensureIndexSize(indexCnt, false);
        this.decodeVarintArray(indexCnt, this.mElem.index);
        int[] index = this.mElem.index;
        int coordCnt = 0;
        if (shift) {
            int i = 0;
            while (i < indexCnt) {
                coordCnt += index[i];
                int n = i++;
                index[n] = index[n] * 2;
            }
        }
        if (indexCnt < index.length) {
            index[indexCnt] = -1;
        }
        return coordCnt;
    }

    private boolean decodeTileElement(int type) throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        int end = this.position() + bytes;
        int numIndices = 1;
        int numTags = 1;
        boolean fail = false;
        int coordCnt = 0;
        if (type == 23) {
            coordCnt = 1;
            this.mElem.index[0] = 2;
        }
        this.mElem.layer = 5;
        block15: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 11: {
                    if (this.decodeElementTags(numTags)) continue block15;
                    return false;
                }
                case 1: {
                    numIndices = this.decodeVarint32();
                    break;
                }
                case 2: {
                    numTags = this.decodeVarint32();
                    break;
                }
                case 3: {
                    coordCnt = this.decodeVarint32();
                    break;
                }
                case 12: {
                    if (type == 24) {
                        this.decodeWayIndices(numIndices, false);
                        break;
                    }
                    coordCnt = this.decodeWayIndices(numIndices, true);
                    break;
                }
                case 13: {
                    int cnt;
                    if (coordCnt == 0) {
                        log.debug("{} no coordinates", (Object)this.mTile);
                    }
                    if (type == 24) {
                        this.mElem.ensurePointSize(coordCnt * 3 / 2, false);
                        cnt = this.decodeInterleavedPoints3D(this.mElem.points, 1.0f);
                        if (cnt != 3 * coordCnt) {
                            log.debug("{} wrong number of coordintes {}/{}", new Object[]{this.mTile, coordCnt, cnt});
                            fail = true;
                        }
                        this.mElem.pointNextPos = cnt;
                        break;
                    }
                    this.mElem.ensurePointSize(coordCnt, false);
                    cnt = this.decodeInterleavedPoints(this.mElem, this.mScaleFactor);
                    if (cnt == coordCnt) continue block15;
                    log.debug("{} wrong number of coordintes {}/{}", new Object[]{this.mTile, coordCnt, cnt});
                    fail = true;
                    break;
                }
                case 21: {
                    this.mElem.layer = this.decodeVarint32();
                    break;
                }
                default: {
                    log.debug("{} invalid type for way: {}", (Object)this.mTile, (Object)tag);
                }
            }
        }
        if (fail || numTags == 0 || numIndices == 0) {
            log.debug("{} failed: bytes:{} tags:{} ({},{})", new Object[]{this.mTile, bytes, this.mElem.tags, numIndices, coordCnt});
            return false;
        }
        switch (type) {
            case 21: {
                this.mElem.type = GeometryBuffer.GeometryType.LINE;
                break;
            }
            case 22: {
                this.mElem.type = GeometryBuffer.GeometryType.POLY;
                break;
            }
            case 23: {
                this.mElem.type = GeometryBuffer.GeometryType.POINT;
                break;
            }
            case 24: {
                this.mElem.type = GeometryBuffer.GeometryType.TRIS;
            }
        }
        this.mMapDataSink.process(this.mElem);
        return true;
    }

    private boolean decodeElementTags(int numTags) throws IOException {
        if (this.mSArray.length < numTags) {
            this.mSArray = new int[numTags];
        }
        int[] tagIds = this.mSArray;
        this.decodeVarintArray(numTags, tagIds);
        this.mElem.tags.clear();
        int max = this.mTileTags.size() - 1;
        for (int i = 0; i < numTags; ++i) {
            int idx = tagIds[i];
            if (idx < 0 || idx > max) {
                log.debug("{} invalid tag:{}", new Object[]{this.mTile, idx, i});
                return false;
            }
            this.mElem.tags.add(this.mTileTags.get(idx));
        }
        return true;
    }
}

