/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.List;
import java.util.Map;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.utils.BitmapPacker;
import org.oscim.utils.math.MathUtils;

public class TextureAtlasUtils {
    private static final int MAX_ATLAS_SIZE = 2048;
    private static final int PAD = 2;

    public static void createTextureRegions(Map<Object, Bitmap> inputMap, Map<Object, TextureRegion> outputMap, List<TextureAtlas> atlasList, boolean disposeBitmaps, boolean flipY) {
        int completePixel = 4;
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        for (Map.Entry<Object, Bitmap> entry : inputMap.entrySet()) {
            int height = entry.getValue().getHeight();
            completePixel += (entry.getValue().getWidth() + 2) * (height + 2);
            minHeight = Math.min(minHeight, height);
            maxHeight = Math.max(maxHeight, height);
        }
        BitmapPacker.PackStrategy strategy = maxHeight - minHeight < 50 ? new BitmapPacker.SkylineStrategy() : new BitmapPacker.GuillotineStrategy();
        completePixel = (int)((double)completePixel * 1.2);
        int atlasWidth = (int)Math.sqrt(completePixel);
        atlasWidth = MathUtils.nextPowerOfTwo(MathUtils.nextPowerOfTwo(atlasWidth) + 1);
        atlasWidth = Math.min(2048, atlasWidth);
        BitmapPacker bitmapPacker = new BitmapPacker(atlasWidth, atlasWidth, 2, strategy, flipY);
        for (Map.Entry<Object, Bitmap> entry : inputMap.entrySet()) {
            completePixel += (entry.getValue().getWidth() + 2) * (entry.getValue().getHeight() + 2);
            bitmapPacker.add(entry.getKey(), entry.getValue());
        }
        int n = bitmapPacker.getAtlasCount();
        for (int i = 0; i < n; ++i) {
            BitmapPacker.PackerAtlasItem packerAtlasItem = bitmapPacker.getAtlasItem(i);
            TextureAtlas atlas = packerAtlasItem.getAtlas();
            atlasList.add(atlas);
            outputMap.putAll(atlas.getRegions());
        }
        if (disposeBitmaps) {
            for (Bitmap bmp : inputMap.values()) {
                bmp.recycle();
            }
            inputMap.clear();
        }
    }
}

