/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import java.util.Arrays;
import org.oscim.core.Point;
import org.oscim.core.PointF;

public class GeometryBuffer {
    private static final int GROW_INDICES = 64;
    private static final int GROW_POINTS = 512;
    public float[] points;
    public int[] index;
    public int indexCurrentPos;
    public int pointNextPos;
    public GeometryType type;
    private PointF mTmpPoint = new PointF();
    private int pointLimit;

    public GeometryBuffer() {
        this(32, 4);
    }

    public GeometryBuffer(int numPoints, int numIndices) {
        this(new float[numPoints * 2], new int[numIndices]);
    }

    public GeometryBuffer(float[] points, int[] index) {
        if (points == null) {
            points = new float[512];
        }
        if (index == null) {
            index = new int[64];
        }
        this.points = points;
        this.index = index;
        this.type = GeometryType.NONE;
        this.indexCurrentPos = 0;
        this.pointNextPos = 0;
        this.pointLimit = points.length - 2;
    }

    public GeometryBuffer(GeometryBuffer buffer) {
        int indexSize;
        for (indexSize = 0; indexSize < buffer.index.length && buffer.index[indexSize] != -1; ++indexSize) {
        }
        this.points = Arrays.copyOf(buffer.points, buffer.pointNextPos);
        this.index = Arrays.copyOf(buffer.index, indexSize);
        this.pointNextPos = buffer.pointNextPos;
        this.indexCurrentPos = buffer.indexCurrentPos;
        this.type = buffer.type;
    }

    public void getPoint(int i, PointF out) {
        out.x = this.points[i << 1];
        out.y = this.points[(i << 1) + 1];
    }

    public float getPointX(int i) {
        return this.points[i << 1];
    }

    public float getPointY(int i) {
        return this.points[(i << 1) + 1];
    }

    public PointF getPoint(int i) {
        PointF out = this.mTmpPoint;
        out.x = this.points[i << 1];
        out.y = this.points[(i << 1) + 1];
        return out;
    }

    public int getNumPoints() {
        return this.pointNextPos >> 1;
    }

    public GeometryBuffer clear() {
        this.index[0] = 0;
        this.indexCurrentPos = 0;
        this.pointNextPos = 0;
        this.type = GeometryType.NONE;
        return this;
    }

    public GeometryBuffer addPoint(float x, float y) {
        if (this.pointNextPos > this.pointLimit) {
            this.ensurePointSize((this.pointNextPos >> 1) + 1, true);
        }
        this.points[this.pointNextPos++] = x;
        this.points[this.pointNextPos++] = y;
        int n = this.indexCurrentPos;
        this.index[n] = this.index[n] + 2;
        return this;
    }

    public boolean isPoly() {
        return this.type == GeometryType.POLY;
    }

    public boolean isLine() {
        return this.type == GeometryType.LINE;
    }

    public boolean isPoint() {
        return this.type == GeometryType.POINT;
    }

    public boolean isTris() {
        return this.type == GeometryType.TRIS;
    }

    public void setPoint(int pos, float x, float y) {
        this.points[(pos << 1) + 0] = x;
        this.points[(pos << 1) + 1] = y;
    }

    public void startPoints() {
        this.setOrCheckMode(GeometryType.POINT);
    }

    public GeometryBuffer startLine() {
        this.setOrCheckMode(GeometryType.LINE);
        if (this.index[this.indexCurrentPos] > 0) {
            if (this.index[0] >= 0 && ++this.indexCurrentPos >= this.index.length) {
                this.ensureIndexSize(this.indexCurrentPos, true);
            }
            this.index[this.indexCurrentPos] = 0;
        }
        if (this.index.length > this.indexCurrentPos + 1) {
            this.index[this.indexCurrentPos + 1] = -1;
        }
        return this;
    }

    public GeometryBuffer startPolygon() {
        boolean start = this.type == GeometryType.NONE;
        this.setOrCheckMode(GeometryType.POLY);
        if (this.indexCurrentPos + 3 > this.index.length) {
            this.ensureIndexSize(this.indexCurrentPos + 2, true);
        }
        if (!start && this.index[this.indexCurrentPos] != 0) {
            this.index[++this.indexCurrentPos] = 0;
            ++this.indexCurrentPos;
        }
        this.index[this.indexCurrentPos] = 0;
        if (this.index.length > this.indexCurrentPos + 1) {
            this.index[this.indexCurrentPos + 1] = -1;
        }
        return this;
    }

    public void startHole() {
        this.checkMode(GeometryType.POLY);
        if (this.indexCurrentPos + 2 > this.index.length) {
            this.ensureIndexSize(this.indexCurrentPos + 1, true);
        }
        this.index[++this.indexCurrentPos] = 0;
        if (this.index.length > this.indexCurrentPos + 1) {
            this.index[this.indexCurrentPos + 1] = -1;
        }
    }

    public GeometryBuffer translate(float dx, float dy) {
        for (int i = 0; i < this.pointNextPos; i += 2) {
            int n = i;
            this.points[n] = this.points[n] + dx;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + dy;
        }
        return this;
    }

    public GeometryBuffer scale(float scaleX, float scaleY) {
        for (int i = 0; i < this.pointNextPos; i += 2) {
            int n = i;
            this.points[n] = this.points[n] * scaleX;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] * scaleY;
        }
        return this;
    }

    public float[] ensurePointSize(int size, boolean copy) {
        if (size * 2 < this.points.length) {
            return this.points;
        }
        size = size * 2 + 512;
        float[] newPoints = new float[size];
        if (copy) {
            System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        }
        this.points = newPoints;
        this.pointLimit = size - 2;
        return this.points;
    }

    public int[] ensureIndexSize(int size, boolean copy) {
        if (size < this.index.length) {
            return this.index;
        }
        int[] newIndex = new int[size + 64];
        if (copy) {
            System.arraycopy(this.index, 0, newIndex, 0, this.index.length);
        }
        this.index = newIndex;
        return this.index;
    }

    private void setOrCheckMode(GeometryType m) {
        if (this.type == m) {
            return;
        }
        if (this.type != GeometryType.NONE) {
            throw new IllegalArgumentException("not cleared " + (Object)((Object)m) + "<>" + (Object)((Object)this.type));
        }
        this.type = m;
    }

    private void checkMode(GeometryType m) {
        if (this.type != m) {
            throw new IllegalArgumentException("not cleared " + (Object)((Object)m) + "<>" + (Object)((Object)this.type));
        }
    }

    public void addPoint(Point p) {
        this.addPoint((float)p.x, (float)p.y);
    }

    public void addPoint(PointF p) {
        this.addPoint(p.x, p.y);
    }

    public void simplify(float minSqDist, boolean keepLines) {
        int outPos = 0;
        int inPos = 0;
        for (int idx = 0; idx < this.index.length && this.index[idx] >= 0; ++idx) {
            if (this.index[idx] == 0) continue;
            int first = inPos;
            float px = this.points[inPos++];
            float py = this.points[inPos++];
            this.points[outPos++] = px;
            this.points[outPos++] = py;
            int cnt = 2;
            int end = this.index[idx];
            for (int pt = 2; pt < end; pt += 2) {
                float cy;
                float dy;
                float cx = this.points[inPos++];
                float dx = cx - px;
                if (dx * dx + (dy = (cy = this.points[inPos++]) - py) * dy < minSqDist && (!keepLines || pt < end - 2)) continue;
                px = cx;
                py = cy;
                this.points[outPos++] = cx;
                this.points[outPos++] = cy;
                cnt += 2;
            }
            if (this.type == GeometryType.POLY && this.points[first] == px && this.points[first + 1] == py) {
                cnt -= 2;
                outPos -= 2;
            }
            this.index[idx] = cnt;
        }
    }

    public float area() {
        if (this.isPoint() || this.isLine() || this.getNumPoints() < 3) {
            return 0.0f;
        }
        float area = 0.0f;
        int n = this.index[0];
        for (int i = 0; i < n - 2; i += 2) {
            area = area + this.points[i] * this.points[i + 3] - this.points[i + 1] * this.points[i + 2];
        }
        area = area + this.points[n - 2] * this.points[1] - this.points[n - 1] * this.points[0];
        return 0.5f * area;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int o = 0;
        for (int i = 0; i < this.index.length && this.index[i] >= 0; ++i) {
            if (!this.isTris()) {
                if (this.index[i] == 0) continue;
                sb.append("POLY (").append(i).append(") { ");
                for (int j = 0; j < this.index[i]; j += 2) {
                    sb.append('[').append(this.points[o + j]).append(", ").append(this.points[o + j + 1]).append(']');
                    if (j % 4 != 0) continue;
                    sb.append('\n');
                }
                sb.append(" } \tnumPoints:").append(this.index[i]).append('\n');
                o += this.index[i];
                continue;
            }
            if (i % 3 == 0) {
                sb.append("TRIS { ");
            }
            sb.append('\t').append(this.index[i]).append('[').append(this.points[3 * this.index[i]]).append(", ").append(this.points[3 * this.index[i] + 1]).append(", ").append(this.points[3 * this.index[i] + 2]).append(']');
            if (i % 3 != 2) continue;
            sb.append(" }\n");
        }
        return sb.toString();
    }

    public static GeometryBuffer makeCircle(float x, float y, float radius, int segments) {
        GeometryBuffer g = new GeometryBuffer(segments, 1);
        GeometryBuffer.makeCircle(g, x, y, radius, segments);
        return g;
    }

    public static GeometryBuffer makeCircle(GeometryBuffer g, float x, float y, float radius, int segments) {
        g.clear();
        g.startPolygon();
        for (int i = 0; i < segments; ++i) {
            double rad = Math.toRadians((float)i * (360.0f / (float)segments));
            g.addPoint((float)((double)x + Math.cos(rad) * (double)radius), (float)((double)y + Math.sin(rad) * (double)radius));
        }
        return g;
    }

    public static enum GeometryType {
        NONE(0),
        POINT(1),
        LINE(2),
        POLY(3),
        TRIS(4);

        public final int nativeInt;

        private GeometryType(int type) {
            this.nativeInt = type;
        }
    }
}

