/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.utils.Utils;

public class Tag {
    public static final String KEY_HOUSE_NUMBER = "addr:housenumber";
    public static final String KEY_NAME = "name";
    public static final String KEY_REF = "ref";
    public static final String KEY_ELE = "ele";
    public static final String KEY_ID = "id";
    public static final String KEY_AMENITY = "amenity";
    public static final String KEY_BUILDING = "building";
    public static final String KEY_HIGHWAY = "highway";
    public static final String KEY_LANDUSE = "landuse";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String KEY_AREA = "area";
    public static final String KEY_BUILDING_COLOR = "building:colour";
    public static final String KEY_BUILDING_LEVELS = "building:levels";
    public static final String KEY_BUILDING_MATERIAL = "building:material";
    public static final String KEY_BUILDING_MIN_LEVEL = "building:min_level";
    public static final String KEY_BUILDING_PART = "building:part";
    public static final String KEY_COLOR = "colour";
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_MATERIAL = "material";
    public static final String KEY_MIN_HEIGHT = "min_height";
    public static final String KEY_ROOF = "roof";
    public static final String KEY_ROOF_ANGLE = "roof:angle";
    public static final String KEY_ROOF_COLOR = "roof:colour";
    public static final String KEY_ROOF_DIRECTION = "roof:direction";
    public static final String KEY_ROOF_HEIGHT = "roof:height";
    public static final String KEY_ROOF_LEVELS = "roof:levels";
    public static final String KEY_ROOF_MATERIAL = "roof:material";
    public static final String KEY_ROOF_ORIENTATION = "roof:orientation";
    public static final String KEY_ROOF_SHAPE = "roof:shape";
    public static final String KEY_VOLUME = "volume";
    public static final String VALUE_DOME = "dome";
    public static final String VALUE_FLAT = "flat";
    public static final String VALUE_GABLED = "gabled";
    public static final String VALUE_GAMBREL = "gambrel";
    public static final String VALUE_HALF_HIPPED = "half_hipped";
    public static final String VALUE_HIPPED = "hipped";
    public static final String VALUE_MANSARD = "mansard";
    public static final String VALUE_ONION = "onion";
    public static final String VALUE_PYRAMIDAL = "pyramidal";
    public static final String VALUE_ROUND = "round";
    public static final String VALUE_SALTBOX = "saltbox";
    public static final String VALUE_SKILLION = "skillion";
    public static final String VALUE_ACROSS = "across";
    public final String key;
    public String value;
    private final boolean intern;
    private int hashCodeValue = 0;

    public Tag(String key, String value) {
        this.key = key == null ? null : key.intern();
        this.value = value == null ? null : value.intern();
        this.intern = true;
    }

    public Tag(String key, String value, boolean internValue) {
        this.key = key;
        this.value = value == null || !internValue ? value : value.intern();
        this.intern = internValue;
    }

    public Tag(String key, String value, boolean internKey, boolean internValue) {
        this.key = key == null || !internKey ? key : key.intern();
        this.value = value == null || !internValue ? value : value.intern();
        this.intern = internValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        if (!Utils.equals(this.key, other.key)) {
            return false;
        }
        return this.intern && other.intern ? Utils.equals(this.value, other.value) : !this.intern && this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.calculateHashCode();
        }
        return this.hashCodeValue;
    }

    public String toString() {
        return "Tag[" + this.key + ',' + this.value + ']';
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public static Tag parse(String tag) {
        int splitPosition = tag.indexOf(61);
        if (splitPosition < 0) {
            return new Tag(tag, "");
        }
        return new Tag(tag.substring(0, splitPosition), tag.substring(splitPosition + 1));
    }
}

