/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.styles.LineStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.GeoPointUtils;
import org.oscim.utils.async.SimpleWorker;
import org.oscim.utils.geom.LineClipper;

public class PathLayer
extends Layer
implements GestureListener {
    protected final ArrayList<GeoPoint> mPoints;
    protected boolean mUpdatePoints;
    private final Point mPoint1 = new Point();
    private final Point mPoint2 = new Point();
    LineStyle mLineStyle;
    final Worker mWorker;
    GeometryBuffer mGeom;

    public PathLayer(Map map, LineStyle style) {
        super(map);
        this.mLineStyle = style;
        this.mPoints = new ArrayList();
        this.mRenderer = new RenderPath();
        this.mWorker = new Worker(map);
    }

    public PathLayer(Map map, int lineColor, float lineWidth) {
        this(map, new LineStyle(lineColor, lineWidth, Paint.Cap.BUTT));
    }

    public PathLayer(Map map, int lineColor) {
        this(map, lineColor, 2.0f);
    }

    public void setStyle(LineStyle style) {
        this.mLineStyle = style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPath() {
        if (this.mPoints.isEmpty()) {
            return;
        }
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.clear();
        }
        this.updatePoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(Collection<? extends GeoPoint> pts) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.clear();
            this.mPoints.addAll(pts);
        }
        this.updatePoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(GeoPoint pt) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.add(pt);
        }
        this.updatePoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(int latitudeE6, int longitudeE6) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.add(new GeoPoint(latitudeE6, longitudeE6));
        }
        this.updatePoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoints(Collection<? extends GeoPoint> pts) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            this.mPoints.addAll(pts);
        }
        this.updatePoints();
    }

    private void updatePoints() {
        this.mWorker.submit(10L);
        this.mUpdatePoints = true;
    }

    public List<GeoPoint> getPoints() {
        return this.mPoints;
    }

    public void setGeom(GeometryBuffer geom) {
        this.mGeom = geom;
        this.mWorker.submit(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint) {
        ArrayList<GeoPoint> arrayList = this.mPoints;
        synchronized (arrayList) {
            double length = startPoint.sphericalDistance(endPoint);
            int numberOfPoints = (int)(length / 100000.0);
            if (numberOfPoints == 0) {
                return;
            }
            this.addGreatCircle(startPoint, endPoint, numberOfPoints);
        }
    }

    public void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * Math.PI / 180.0;
        double lon1 = startPoint.getLongitude() * Math.PI / 180.0;
        double lat2 = endPoint.getLatitude() * Math.PI / 180.0;
        double lon2 = endPoint.getLongitude() * Math.PI / 180.0;
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        double bearing = Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) / (-Math.PI / 180);
        bearing = bearing < 0.0 ? 360.0 + bearing : bearing;
        int j = numberOfPoints + 1;
        for (int i = 0; i < j; ++i) {
            double f = 1.0 / (double)numberOfPoints * (double)i;
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            this.addPoint((int)(latN / (Math.PI / 180) * 1000000.0), (int)(lonN / (Math.PI / 180) * 1000000.0));
        }
    }

    public synchronized boolean contains(float x, float y) {
        double distance = Math.max(10.0f * CanvasAdapter.getScale(), this.mLineStyle.width);
        for (int i = 0; i < this.mPoints.size() - 1; ++i) {
            if (i == 0) {
                this.mMap.viewport().toScreenPoint(this.mPoints.get(i), false, this.mPoint1);
            } else {
                this.mPoint1.x = this.mPoint2.x;
                this.mPoint1.y = this.mPoint2.y;
            }
            this.mMap.viewport().toScreenPoint(this.mPoints.get(i + 1), false, this.mPoint2);
            if (!(GeoPointUtils.distanceSegmentPoint(this.mPoint1.x, this.mPoint1.y, this.mPoint2.x, this.mPoint2.y, x, y) <= distance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onGesture(Gesture g, MotionEvent e) {
        return false;
    }

    final class Worker
    extends SimpleWorker<Task> {
        private final int max = 2048;
        private static final int MIN_DIST = 3;
        private double[] mPreprojected;
        private float[] mPPoints;
        private final LineClipper mClipper;
        private int mNumPoints;

        public Worker(Map map) {
            super(map, 0L, new Task(), new Task());
            this.max = 2048;
            this.mPreprojected = new double[2];
            this.mClipper = new LineClipper(-2048.0f, -2048.0f, 2048.0f, 2048.0f);
            this.mPPoints = new float[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doWork(Task task) {
            int size = this.mNumPoints;
            if (PathLayer.this.mUpdatePoints) {
                ArrayList<GeoPoint> arrayList = PathLayer.this.mPoints;
                synchronized (arrayList) {
                    PathLayer.this.mUpdatePoints = false;
                    this.mNumPoints = size = PathLayer.this.mPoints.size();
                    ArrayList<GeoPoint> geopoints = PathLayer.this.mPoints;
                    double[] points = this.mPreprojected;
                    if (size * 2 >= points.length) {
                        points = this.mPreprojected = new double[size * 2];
                        this.mPPoints = new float[size * 2];
                    }
                    for (int i = 0; i < size; ++i) {
                        MercatorProjection.project(geopoints.get(i), points, i);
                    }
                }
            } else if (PathLayer.this.mGeom != null) {
                GeometryBuffer geom = PathLayer.this.mGeom;
                PathLayer.this.mGeom = null;
                size = geom.index[0];
                double[] points = this.mPreprojected;
                if (size > points.length) {
                    points = this.mPreprojected = new double[size * 2];
                    this.mPPoints = new float[size * 2];
                }
                for (int i = 0; i < size; i += 2) {
                    MercatorProjection.project(geom.points[i + 1], geom.points[i], points, i >> 1);
                }
                this.mNumPoints = size >>= 1;
            }
            if (size == 0) {
                if (task.bucket.get() != null) {
                    task.bucket.clear();
                    this.mMap.render();
                }
                return true;
            }
            LineBucket ll = PathLayer.this.mLineStyle.stipple == 0 && PathLayer.this.mLineStyle.texture == null ? task.bucket.getLineBucket(0) : task.bucket.getLineTexBucket(0);
            ll.line = PathLayer.this.mLineStyle;
            this.mMap.getMapPosition(task.pos);
            int zoomlevel = task.pos.zoomLevel;
            task.pos.scale = 1 << zoomlevel;
            double mx = task.pos.x;
            double my = task.pos.y;
            double scale = (double)Tile.SIZE * task.pos.scale;
            int flip = 0;
            int maxx = Tile.SIZE << zoomlevel - 1;
            int x = (int)((this.mPreprojected[0] - mx) * scale);
            int y = (int)((this.mPreprojected[1] - my) * scale);
            if (x > maxx) {
                x -= maxx * 2;
                flip = -1;
            } else if (x < -maxx) {
                x += maxx * 2;
                flip = 1;
            }
            this.mClipper.clipStart(x, y);
            float[] projected = this.mPPoints;
            int i = this.addPoint(projected, 0, x, y);
            float prevX = x;
            float prevY = y;
            float[] segment = null;
            for (int j = 2; j < size * 2; j += 2) {
                x = (int)((this.mPreprojected[j + 0] - mx) * scale);
                y = (int)((this.mPreprojected[j + 1] - my) * scale);
                int flipDirection = 0;
                if (x > maxx) {
                    x -= maxx * 2;
                    flipDirection = -1;
                } else if (x < -maxx) {
                    x += maxx * 2;
                    flipDirection = 1;
                }
                if (flip != flipDirection) {
                    flip = flipDirection;
                    if (i > 2) {
                        ll.addLine(projected, i, false);
                    }
                    this.mClipper.clipStart(x, y);
                    i = this.addPoint(projected, 0, x, y);
                    continue;
                }
                int clip = this.mClipper.clipNext(x, y);
                if (clip < 1) {
                    if (i > 2) {
                        ll.addLine(projected, i, false);
                    }
                    if (clip < 0) {
                        segment = this.mClipper.getLine(segment, 0);
                        ll.addLine(segment, 4, false);
                        prevX = x;
                        prevY = y;
                    }
                    i = 0;
                    if (this.mClipper.getPrevOutcode() != 0) continue;
                    projected[i++] = prevX;
                    projected[i++] = prevY;
                    continue;
                }
                float dx = (float)x - prevX;
                float dy = (float)y - prevY;
                if (i != 0 && !FastMath.absMaxCmp(dx, dy, 3.0f)) continue;
                projected[i++] = prevX = (float)x;
                projected[i++] = prevY = (float)y;
            }
            if (i > 2) {
                ll.addLine(projected, i, false);
            }
            this.mMap.render();
            return true;
        }

        @Override
        public void cleanup(Task task) {
            task.bucket.clear();
        }

        private int addPoint(float[] points, int i, int x, int y) {
            points[i++] = x;
            points[i++] = y;
            return i;
        }
    }

    static final class Task {
        RenderBuckets bucket = new RenderBuckets();
        MapPosition pos = new MapPosition();

        Task() {
        }
    }

    final class RenderPath
    extends BucketRenderer {
        private int mCurX = -1;
        private int mCurY = -1;
        private int mCurZ = -1;

        RenderPath() {
        }

        @Override
        public synchronized void update(GLViewport v) {
            Task t;
            int tz = 1 << v.pos.zoomLevel;
            int tx = (int)(v.pos.x * (double)tz);
            int ty = (int)(v.pos.y * (double)tz);
            if (tx != this.mCurX || ty != this.mCurY || tz != this.mCurZ) {
                PathLayer.this.mWorker.submit(100L);
                this.mCurX = tx;
                this.mCurY = ty;
                this.mCurZ = tz;
            }
            if ((t = (Task)PathLayer.this.mWorker.poll()) == null) {
                return;
            }
            this.mMapPosition.copy(t.pos);
            this.buckets.set(t.bucket.get());
            this.compile();
        }
    }
}

