/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.backend.canvas.Color;
import org.oscim.utils.ColorUtil;
import org.oscim.utils.ColorsCSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3DBUtils {
    private static final Logger log = LoggerFactory.getLogger(S3DBUtils.class);
    private static final double HSV_S = 0.7;
    private static final double HSV_V = 1.2;

    public static int getColor(String color, boolean roof) {
        if (color.charAt(0) == '#') {
            int c = Color.parseColor(color, -16711681);
            return ColorUtil.modHsv(c, 1.0, 0.4, 1.2, true);
        }
        if (roof) {
            if ("brown".equals(color)) {
                return Color.get(120, 110, 110);
            }
            if ("red".equals(color)) {
                return Color.get(235, 140, 130);
            }
            if ("green".equals(color)) {
                return Color.get(150, 200, 130);
            }
            if ("blue".equals(color)) {
                return Color.get(100, 50, 200);
            }
        }
        if ("white".equals(color)) {
            return Color.get(240, 240, 240);
        }
        if ("black".equals(color)) {
            return Color.get(86, 86, 86);
        }
        if ("grey".equals(color) || "gray".equals(color)) {
            return Color.get(120, 120, 120);
        }
        if ("red".equals(color)) {
            return Color.get(255, 190, 190);
        }
        if ("green".equals(color)) {
            return Color.get(190, 255, 190);
        }
        if ("blue".equals(color)) {
            return Color.get(190, 190, 255);
        }
        if ("yellow".equals(color)) {
            return Color.get(255, 255, 175);
        }
        if ("darkgray".equals(color) || "darkgrey".equals(color)) {
            return -12303292;
        }
        if ("lightgray".equals(color) || "lightgrey".equals(color)) {
            return -3355444;
        }
        if ("transparent".equals(color)) {
            return Color.get(0, 1, 1, 1);
        }
        Integer css = ColorsCSS.get(color);
        if (css != null) {
            return ColorUtil.modHsv(css, 1.0, 0.7, 1.2, true);
        }
        log.debug("unknown color:{}", (Object)color);
        return 0;
    }

    public static int getMaterialColor(String material, boolean roof) {
        if (roof && "glass".equals(material)) {
            return Color.fade(Color.get(130, 224, 255), 0.9f);
        }
        if ("roof_tiles".equals(material)) {
            return Color.get(216, 167, 111);
        }
        if ("tile".equals(material)) {
            return Color.get(216, 167, 111);
        }
        if ("concrete".equals(material) || "cement_block".equals(material)) {
            return Color.get(210, 212, 212);
        }
        if ("metal".equals(material)) {
            return -4144960;
        }
        if ("tar_paper".equals(material)) {
            return -6907496;
        }
        if ("eternit".equals(material)) {
            return Color.get(216, 167, 111);
        }
        if ("tin".equals(material)) {
            return -4144960;
        }
        if ("asbestos".equals(material)) {
            return Color.get(160, 152, 141);
        }
        if ("glass".equals(material)) {
            return Color.get(130, 224, 255);
        }
        if ("slate".equals(material)) {
            return -10462880;
        }
        if ("zink".equals(material)) {
            return Color.get(180, 180, 180);
        }
        if ("gravel".equals(material)) {
            return Color.get(170, 130, 80);
        }
        if ("copper".equals(material)) {
            return Color.get(150, 200, 130);
        }
        if ("wood".equals(material)) {
            return Color.get(170, 130, 80);
        }
        if ("grass".equals(material)) {
            return -11490736;
        }
        if ("stone".equals(material)) {
            return Color.get(206, 207, 181);
        }
        if ("plaster".equals(material)) {
            return Color.get(236, 237, 181);
        }
        if ("brick".equals(material)) {
            return Color.get(255, 217, 191);
        }
        if ("stainless_steel".equals(material)) {
            return Color.get(153, 157, 160);
        }
        if ("gold".equals(material)) {
            return -10496;
        }
        log.debug("unknown material:{}", (Object)material);
        return 0;
    }

    private S3DBUtils() {
    }
}

