/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.core.BoundingBox;
import org.oscim.core.Box;
import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.event.EventDispatcher;
import org.oscim.event.EventListener;
import org.oscim.event.Gesture;
import org.oscim.event.MotionEvent;
import org.oscim.layers.AbstractMapEventLayer;
import org.oscim.layers.Layer;
import org.oscim.layers.MapEventLayer;
import org.oscim.layers.MapEventLayer2;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.vector.OsmTileLayer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Animator;
import org.oscim.map.Layers;
import org.oscim.map.ViewController;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeLoader;
import org.oscim.tiling.TileSource;
import org.oscim.utils.Parameters;
import org.oscim.utils.ThreadUtils;
import org.oscim.utils.async.AsyncExecutor;
import org.oscim.utils.async.TaskQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Map
implements TaskQueue {
    private static final Logger log = LoggerFactory.getLogger(Map.class);
    public static final Event POSITION_EVENT = new Event();
    public static final Event MOVE_EVENT = new Event();
    public static final Event SCALE_EVENT = new Event();
    public static final Event ROTATE_EVENT = new Event();
    public static final Event TILT_EVENT = new Event();
    public static final Event UPDATE_EVENT = new Event();
    public static final Event CLEAR_EVENT = new Event();
    public static final Event ANIM_END = new Event();
    public static final Event ANIM_START = new Event();
    public final EventDispatcher<InputListener, MotionEvent> input;
    public final EventDispatcher<UpdateListener, MapPosition> events;
    private final Layers mLayers;
    private final ViewController mViewport;
    private final AsyncExecutor mAsyncExecutor;
    protected final Animator mAnimator;
    protected final MapPosition mMapPosition;
    protected final AbstractMapEventLayer mEventLayer;
    protected boolean mClearMap = true;

    public Map() {
        ThreadUtils.init();
        this.mViewport = new ViewController();
        this.mAnimator = new Animator(this);
        this.mLayers = new Layers(this);
        this.input = new EventDispatcher<InputListener, MotionEvent>(){

            @Override
            public void tell(InputListener l, Event e, MotionEvent d) {
                l.onInputEvent(e, d);
            }
        };
        this.events = new EventDispatcher<UpdateListener, MapPosition>(){

            @Override
            public void tell(UpdateListener l, Event e, MapPosition d) {
                l.onMapEvent(e, d);
            }
        };
        this.mAsyncExecutor = new AsyncExecutor(4, this);
        this.mMapPosition = new MapPosition();
        this.mEventLayer = Parameters.MAP_EVENT_LAYER2 ? new MapEventLayer2(this) : new MapEventLayer(this);
        this.mLayers.add(0, this.mEventLayer);
    }

    public AbstractMapEventLayer getEventLayer() {
        return this.mEventLayer;
    }

    public VectorTileLayer setBaseMap(TileSource tileSource) {
        OsmTileLayer l = new OsmTileLayer(this);
        l.setTileSource(tileSource);
        this.setBaseMap(l);
        return l;
    }

    public TileLayer setBaseMap(TileLayer tileLayer) {
        this.mLayers.add(1, tileLayer);
        return tileLayer;
    }

    public void setTheme(ThemeFile theme) {
        this.setTheme(theme, false);
    }

    public void setTheme(ThemeFile theme, boolean allLayers) {
        this.setTheme(ThemeLoader.load(theme), allLayers);
    }

    public void setTheme(IRenderTheme theme) {
        this.setTheme(theme, false);
    }

    public void setTheme(IRenderTheme theme, boolean allLayers) {
        if (theme == null) {
            throw new IllegalArgumentException("Theme cannot be null.");
        }
        boolean themeSet = false;
        for (Layer layer : this.mLayers) {
            if (!(layer instanceof VectorTileLayer)) continue;
            ((VectorTileLayer)layer).setRenderTheme(theme);
            themeSet = true;
            if (allLayers) continue;
            break;
        }
        if (!themeSet) {
            log.error("No vector layers set");
            throw new IllegalStateException();
        }
        MapRenderer.setBackgroundColor(theme.getMapBackground());
        this.clearMap();
    }

    public void destroy() {
        this.mLayers.destroy();
        this.mAsyncExecutor.dispose();
    }

    public abstract void updateMap(boolean var1);

    public abstract void render();

    @Override
    public abstract boolean post(Runnable var1);

    public abstract boolean postDelayed(Runnable var1, long var2);

    @Override
    public void addTask(Runnable task) {
        this.mAsyncExecutor.post(task);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void clearMap() {
        this.mClearMap = true;
        this.updateMap(true);
    }

    public void setMapPosition(final MapPosition mapPosition) {
        if (!ThreadUtils.isMainThread()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Map.this.mViewport.setMapPosition(mapPosition);
                    Map.this.updateMap(true);
                }
            });
        } else {
            this.mViewport.setMapPosition(mapPosition);
            this.updateMap(true);
        }
    }

    public void setMapPosition(double latitude, double longitude, double scale) {
        this.mViewport.setMapPosition(new MapPosition(latitude, longitude, scale));
        this.updateMap(true);
    }

    public boolean getMapPosition(boolean animationEnd, MapPosition mapPosition) {
        if (animationEnd && this.animator().isActive()) {
            mapPosition.copy(this.animator().getEndPosition());
            return true;
        }
        if (!ThreadUtils.isMainThread()) {
            return this.mViewport.getSyncMapPosition(mapPosition);
        }
        return this.mViewport.getMapPosition(mapPosition);
    }

    public boolean getMapPosition(MapPosition mapPosition) {
        return this.getMapPosition(false, mapPosition);
    }

    public MapPosition getMapPosition() {
        MapPosition pos = new MapPosition();
        this.mViewport.getMapPosition(pos);
        return pos;
    }

    public BoundingBox getBoundingBox(int expand) {
        Box box = new Box();
        this.mViewport.getBBox(box, expand);
        box.map2mercator();
        return new BoundingBox(box.ymin, box.xmin, box.ymax, box.xmax);
    }

    public ViewController viewport() {
        return this.mViewport;
    }

    public Layers layers() {
        return this.mLayers;
    }

    public Animator animator() {
        return this.mAnimator;
    }

    protected void prepareFrame() {
        ThreadUtils.assertMainThread();
        MapPosition pos = this.mMapPosition;
        this.mAnimator.updateAnimation();
        boolean changed = this.mViewport.getMapPosition(pos);
        boolean sizeChanged = this.mViewport.sizeChanged();
        if (this.mClearMap) {
            this.events.fire(CLEAR_EVENT, pos);
        } else if (changed || sizeChanged) {
            this.events.fire(POSITION_EVENT, pos);
        } else {
            this.events.fire(UPDATE_EVENT, pos);
        }
        this.mClearMap = false;
        this.mAnimator.updateAnimation();
        this.mViewport.syncViewport();
    }

    public boolean handleGesture(Gesture g, MotionEvent e) {
        return this.mLayers.handleGesture(g, e);
    }

    public abstract void beginFrame();

    public abstract void doneFrame(boolean var1);

    public static interface InputListener
    extends EventListener {
        public void onInputEvent(Event var1, MotionEvent var2);
    }

    public static interface UpdateListener
    extends EventListener {
        public void onMapEvent(Event var1, MapPosition var2);
    }
}

