/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtrusionRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(ExtrusionRenderer.class);
    private final boolean mTranslucent;
    private final int mMode;
    private Shader mShader;
    protected ExtrusionBuckets[] mExtrusionBucketSet = new ExtrusionBuckets[0];
    protected int mBucketsCnt;
    protected float mAlpha = 1.0f;
    private float mZLimit = Float.MAX_VALUE;

    public ExtrusionRenderer(boolean mesh, boolean alpha) {
        this.mMode = mesh ? 1 : 0;
        this.mTranslucent = alpha;
    }

    @Override
    public boolean setup() {
        this.mShader = this.mMode == 0 ? new Shader("extrusion_layer_ext") : new Shader("extrusion_layer_mesh");
        return true;
    }

    private void renderCombined(int vertexPointer, ExtrusionBuckets ebs) {
        for (ExtrusionBucket eb = ebs.buckets(); eb != null; eb = eb.next()) {
            GLAdapter.gl.vertexAttribPointer(vertexPointer, 3, 5122, false, 8, eb.getVertexOffset());
            int sumIndices = eb.idx[0] + eb.idx[1] + eb.idx[2];
            if (sumIndices > 0) {
                GLAdapter.gl.drawElements(4, sumIndices, 5123, eb.off[0]);
            }
            if (eb.idx[4] <= 0) continue;
            GLAdapter.gl.drawElements(4, eb.idx[4], 5123, eb.off[4]);
        }
    }

    @Override
    public void render(GLViewport v) {
        float alpha;
        int i;
        float[] currentColors = null;
        float currentAlpha = 0.0f;
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.clear(256);
        GLState.test(true, false);
        Shader s = this.mShader;
        s.useProgram();
        GLState.enableVertexArrays(s.aPos, -1);
        if (v.pos.zoomLevel < 18) {
            GLAdapter.gl.enable(2884);
        }
        GLAdapter.gl.depthFunc(513);
        GLAdapter.gl.uniform1f(s.uAlpha, this.mAlpha);
        GLAdapter.gl.uniform1f(s.uZLimit, this.mZLimit);
        ExtrusionBuckets[] ebs = this.mExtrusionBucketSet;
        if (this.mTranslucent) {
            GLState.blend(false);
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.uniform1i(s.uMode, -1);
            for (i = 0; i < this.mBucketsCnt; ++i) {
                if (ebs[i].ibo == null) {
                    return;
                }
                ebs[i].ibo.bind();
                ebs[i].vbo.bind();
                this.setMatrix(s, v, ebs[i]);
                alpha = this.mAlpha * this.getFade(ebs[i]);
                if (alpha != currentAlpha) {
                    GLAdapter.gl.uniform1f(s.uAlpha, alpha);
                    currentAlpha = alpha;
                }
                this.renderCombined(s.aPos, ebs[i]);
            }
            GLAdapter.gl.colorMask(true, true, true, true);
            GLAdapter.gl.depthMask(false);
            GLAdapter.gl.depthFunc(514);
        }
        GLState.blend(true);
        GLState.enableVertexArrays(s.aPos, s.aLight);
        for (i = 0; i < this.mBucketsCnt; ++i) {
            if (ebs[i].ibo == null) continue;
            ebs[i].ibo.bind();
            ebs[i].vbo.bind();
            if (!this.mTranslucent) {
                this.setMatrix(s, v, ebs[i]);
            }
            if ((alpha = this.mAlpha * this.getFade(ebs[i])) != currentAlpha) {
                GLAdapter.gl.uniform1f(s.uAlpha, alpha);
                currentAlpha = alpha;
            }
            for (ExtrusionBucket eb = ebs[i].buckets(); eb != null; eb = eb.next()) {
                if (eb.getColors() != currentColors) {
                    currentColors = eb.getColors();
                    GLUtils.glUniform4fv(s.uColor, this.mMode == 0 ? 4 : 1, currentColors);
                }
                GLAdapter.gl.vertexAttribPointer(s.aPos, 3, 5122, false, 8, eb.getVertexOffset());
                GLAdapter.gl.vertexAttribPointer(s.aLight, 2, 5121, false, 8, eb.getVertexOffset() + 6);
                if (eb.idx[0] > 0) {
                    if (this.mTranslucent) {
                        GLAdapter.gl.depthFunc(514);
                        this.setMatrix(s, v, ebs[i]);
                    }
                    GLAdapter.gl.uniform1i(s.uMode, 0);
                    GLAdapter.gl.drawElements(4, eb.idx[2], 5123, eb.off[2]);
                    GLAdapter.gl.uniform1i(s.uMode, 1);
                    GLAdapter.gl.drawElements(4, eb.idx[0], 5123, eb.off[0]);
                    GLAdapter.gl.uniform1i(s.uMode, 2);
                    GLAdapter.gl.drawElements(4, eb.idx[1], 5123, eb.off[1]);
                    if (this.mTranslucent) {
                        GLAdapter.gl.depthFunc(515);
                        v.mvp.addDepthOffset(100);
                        v.mvp.setAsUniform(s.uMVP);
                    }
                    GLAdapter.gl.uniform1i(s.uMode, 3);
                    GLAdapter.gl.drawElements(1, eb.idx[3], 5123, eb.off[3]);
                }
                if (eb.idx[4] <= 0) continue;
                GLAdapter.gl.drawElements(4, eb.idx[4], 5123, eb.off[4]);
            }
            ebs[i] = null;
        }
        if (!this.mTranslucent) {
            GLAdapter.gl.depthMask(false);
        }
        if (v.pos.zoomLevel < 18) {
            GLAdapter.gl.disable(2884);
        }
    }

    private float getFade(ExtrusionBuckets ebs) {
        if (ebs.animTime == 0L) {
            ebs.animTime = MapRenderer.frametime - 50L;
        }
        return FastMath.clamp((float)(MapRenderer.frametime - ebs.animTime) / 300.0f, 0.0f, 1.0f);
    }

    private void setMatrix(Shader s, GLViewport v, ExtrusionBuckets l) {
        int z = l.zoomLevel;
        double curScale = (double)Tile.SIZE * v.pos.scale;
        float scale = (float)(v.pos.scale / (double)(1 << z));
        float x = (float)((l.x - v.pos.x) * curScale);
        float y = (float)((l.y - v.pos.y) * curScale);
        v.mvp.setTransScale(x, y, scale / MapRenderer.COORD_SCALE);
        v.mvp.setValue(10, scale / 10.0f);
        v.mvp.multiplyLhs(v.viewproj);
        if (this.mTranslucent) {
            int zoom = 1 << z;
            int delta = (int)(l.x * (double)zoom) % 4 + (int)(l.y * (double)zoom) % 4 * 4;
            v.mvp.addDepthOffset(delta);
        }
        v.mvp.setAsUniform(s.uMVP);
    }

    public void setZLimit(float zLimit) {
        this.mZLimit = zLimit;
    }

    public static class Shader
    extends GLShader {
        int uMVP;
        int uColor;
        int uAlpha;
        int uMode;
        int aPos;
        int aLight;
        int uZLimit;

        public Shader(String shader) {
            if (!this.create(shader)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uColor = this.getUniform("u_color");
            this.uAlpha = this.getUniform("u_alpha");
            this.uMode = this.getUniform("u_mode");
            this.uZLimit = this.getUniform("u_zlimit");
            this.aPos = this.getAttrib("a_pos");
            this.aLight = this.getAttrib("a_light");
        }
    }
}

