/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLUtils {
    static final Logger log = LoggerFactory.getLogger(GLUtils.class);

    public static void setColor(int location, int color, float alpha) {
        alpha = alpha >= 1.0f ? (float)(color >>> 24 & 0xFF) / 255.0f : (alpha < 0.0f ? 0.0f : (alpha *= (float)(color >>> 24 & 0xFF) / 255.0f));
        if (alpha == 1.0f) {
            GLAdapter.gl.uniform4f(location, (float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color >>> 0 & 0xFF) / 255.0f, alpha);
        } else {
            GLAdapter.gl.uniform4f(location, (float)(color >>> 16 & 0xFF) / 255.0f * alpha, (float)(color >>> 8 & 0xFF) / 255.0f * alpha, (float)(color >>> 0 & 0xFF) / 255.0f * alpha, alpha);
        }
    }

    public static void setColorBlend(int location, int color1, int color2, float mix) {
        float a1 = (float)(color1 >>> 24 & 0xFF) / 255.0f * (1.0f - mix);
        float a2 = (float)(color2 >>> 24 & 0xFF) / 255.0f * mix;
        GLAdapter.gl.uniform4f(location, (float)(color1 >>> 16 & 0xFF) / 255.0f * a1 + (float)(color2 >>> 16 & 0xFF) / 255.0f * a2, (float)(color1 >>> 8 & 0xFF) / 255.0f * a1 + (float)(color2 >>> 8 & 0xFF) / 255.0f * a2, (float)(color1 >>> 0 & 0xFF) / 255.0f * a1 + (float)(color2 >>> 0 & 0xFF) / 255.0f * a2, a1 + a2);
    }

    public static void setTextureParameter(int min_filter, int mag_filter, int wrap_s, int wrap_t) {
        GLAdapter.gl.texParameterf(3553, 10241, min_filter);
        GLAdapter.gl.texParameterf(3553, 10240, mag_filter);
        GLAdapter.gl.texParameterf(3553, 10242, wrap_s);
        GLAdapter.gl.texParameterf(3553, 10243, wrap_t);
    }

    public static int loadTexture(byte[] pixel, int width, int height, int format, int min_filter, int mag_filter, int wrap_s, int wrap_t) {
        int[] textureIds = GLUtils.glGenTextures(1);
        GLState.bindTex2D(textureIds[0]);
        GLUtils.setTextureParameter(min_filter, mag_filter, wrap_s, wrap_t);
        ByteBuffer buf = ByteBuffer.allocateDirect(width * height).order(ByteOrder.nativeOrder());
        buf.put(pixel);
        buf.position(0);
        IntBuffer intBuf = buf.asIntBuffer();
        GLAdapter.gl.texImage2D(3553, 0, format, width, height, 0, format, 5121, intBuf);
        GLState.bindTex2D(0);
        return textureIds[0];
    }

    public static void checkGlError(String op) {
        int error;
        while ((error = GLAdapter.gl.getError()) != 0) {
            log.error(op + ": glError " + error);
        }
    }

    public static boolean checkGlOutOfMemory(String op) {
        int error;
        boolean oom = false;
        while ((error = GLAdapter.gl.getError()) != 0) {
            log.error(op + ": glError " + error);
            if (error != 1285) continue;
            oom = true;
        }
        return oom;
    }

    public static void setColor(int handle, float[] c, float alpha) {
        if (alpha >= 1.0f) {
            GLAdapter.gl.uniform4f(handle, c[0], c[1], c[2], c[3]);
        } else {
            if (alpha < 0.0f) {
                log.debug("setColor: " + alpha);
                alpha = 0.0f;
                GLAdapter.gl.uniform4f(handle, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            GLAdapter.gl.uniform4f(handle, c[0] * alpha, c[1] * alpha, c[2] * alpha, c[3] * alpha);
        }
    }

    public static float[] colorToFloat(int color) {
        float[] c = new float[4];
        c[3] = (float)(color >> 24 & 0xFF) / 255.0f;
        c[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        c[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        c[2] = (float)(color >> 0 & 0xFF) / 255.0f;
        return c;
    }

    public static float[] colorToFloatP(int color) {
        float[] c = new float[4];
        c[3] = (float)(color >> 24 & 0xFF) / 255.0f;
        c[0] = (float)(color >> 16 & 0xFF) / 255.0f * c[3];
        c[1] = (float)(color >> 8 & 0xFF) / 255.0f * c[3];
        c[2] = (float)(color >> 0 & 0xFF) / 255.0f * c[3];
        return c;
    }

    public static void changeSaturation(float[] color, float change) {
        float r = color[0];
        float g = color[1];
        float b = color[2];
        double p = Math.sqrt(r * r * 0.299f + g * g * 0.587f + b * b * 0.114f);
        color[0] = FastMath.clampN((float)(p + ((double)r - p) * (double)change));
        color[1] = FastMath.clampN((float)(p + ((double)g - p) * (double)change));
        color[2] = FastMath.clampN((float)(p + ((double)b - p) * (double)change));
    }

    public static void glUniform4fv(int location, int count, float[] val) {
        FloatBuffer buf = MapRenderer.getFloatBuffer(count * 4);
        buf.put(val);
        buf.flip();
        GLAdapter.gl.uniform4fv(location, count, buf);
    }

    public static int[] glGenBuffers(int num) {
        IntBuffer buf = MapRenderer.getIntBuffer(num);
        buf.position(0);
        buf.limit(num);
        GLAdapter.gl.genBuffers(num, buf);
        int[] ret = new int[num];
        buf.position(0);
        buf.limit(num);
        buf.get(ret);
        return ret;
    }

    public static void glDeleteBuffers(int num, int[] ids) {
        IntBuffer buf = MapRenderer.getIntBuffer(num);
        buf.put(ids, 0, num);
        buf.flip();
        GLAdapter.gl.deleteBuffers(num, buf);
    }

    public static int[] glGenTextures(int num) {
        if (num <= 0) {
            return null;
        }
        int[] ret = new int[num];
        IntBuffer buf = GLAdapter.GDX_DESKTOP_QUIRKS ? ByteBuffer.allocateDirect(num * 4).order(ByteOrder.nativeOrder()).asIntBuffer() : MapRenderer.getIntBuffer(num);
        if (GLAdapter.GDX_WEBGL_QUIRKS) {
            for (int i = 0; i < num; ++i) {
                GLAdapter.gl.genTextures(num, buf);
                buf.position(0);
                ret[i] = buf.get();
                buf.position(0);
            }
        } else {
            GLAdapter.gl.genTextures(num, buf);
            buf.position(0);
            buf.get(ret);
        }
        return ret;
    }

    public static void glDeleteTextures(int num, int[] ids) {
        IntBuffer buf = MapRenderer.getIntBuffer(num);
        buf.put(ids, 0, num);
        buf.flip();
        GLAdapter.gl.deleteTextures(num, buf);
    }
}

