/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.utils.TessJNI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(MeshBucket.class);
    static final boolean dbgRender = false;
    public AreaStyle area;
    public float heightOffset;
    private TessJNI tess;
    private int numPoints;

    public MeshBucket(int level) {
        super((byte)3, true, false);
        this.level = level;
    }

    public void addMesh(GeometryBuffer geom) {
        this.numPoints += geom.pointNextPos;
        if (this.tess == null) {
            this.tess = new TessJNI(8);
        }
        this.tess.addContour2D(geom.index, geom.points);
    }

    public void addConvexMesh(GeometryBuffer geom) {
        short start = (short)this.numVertices;
        if (this.numVertices >= 65536) {
            return;
        }
        this.vertexItems.add(geom.points[0] * MapRenderer.COORD_SCALE, geom.points[1] * MapRenderer.COORD_SCALE);
        this.vertexItems.add(geom.points[2] * MapRenderer.COORD_SCALE, geom.points[3] * MapRenderer.COORD_SCALE);
        short prev = (short)(start + 1);
        this.numVertices += 2;
        for (int i = 4; i < geom.index[0]; i += 2) {
            this.vertexItems.add(geom.points[i + 0] * MapRenderer.COORD_SCALE, geom.points[i + 1] * MapRenderer.COORD_SCALE);
            short s = prev;
            prev = (short)(prev + 1);
            this.indiceItems.add(start, s, prev);
            ++this.numVertices;
            this.numIndices += 3;
        }
    }

    @Override
    protected void prepare() {
        int size;
        int size2;
        if (this.tess == null) {
            return;
        }
        if (this.numPoints == 0) {
            this.tess.dispose();
            return;
        }
        if (!this.tess.tesselate()) {
            this.tess.dispose();
            log.error("error in tessellation {}", (Object)this.numPoints);
            return;
        }
        int nelems = this.tess.getElementCount() * 3;
        for (int offset = this.indiceItems.countSize(); offset < nelems; offset += size2) {
            size2 = nelems - offset;
            if (size2 > 360) {
                size2 = 360;
            }
            VertexData.Chunk chunk = this.indiceItems.obtainChunk();
            this.tess.getElements(chunk.vertices, offset, size2);
            this.indiceItems.releaseChunk(size2);
        }
        int nverts = this.tess.getVertexCount() * 2;
        for (int offset = 0; offset < nverts; offset += size) {
            size = nverts - offset;
            if (size > 360) {
                size = 360;
            }
            VertexData.Chunk chunk = this.vertexItems.obtainChunk();
            this.tess.getVertices(chunk.vertices, offset, size, MapRenderer.COORD_SCALE);
            this.vertexItems.releaseChunk(size);
        }
        this.numIndices += nelems;
        this.numVertices += nverts >> 1;
        this.tess.dispose();
    }

    public static class Renderer {
        static Shader shader;
        private static final int OPAQUE = -16777216;

        static boolean init() {
            shader = new Shader("mesh_layer_2D");
            return true;
        }

        public static RenderBucket draw(RenderBucket l, GLViewport v) {
            GLState.blend(true);
            Shader s = shader;
            s.useProgram();
            GLState.enableVertexArrays(s.aPos, -1);
            v.mvp.setAsUniform(s.uMVP);
            float heightOffset = 0.0f;
            GLAdapter.gl.uniform1f(s.uHeight, heightOffset);
            while (l != null && l.type == 3) {
                MeshBucket ml = (MeshBucket)l;
                AreaStyle area = ml.area.current();
                if (area.heightOffset != ml.heightOffset) {
                    ml.heightOffset = area.heightOffset;
                }
                if (ml.heightOffset != heightOffset) {
                    heightOffset = ml.heightOffset;
                    GLAdapter.gl.uniform1f(s.uHeight, heightOffset / MercatorProjection.groundResolution(v.pos));
                }
                if (ml.area == null) {
                    GLUtils.setColor(s.uColor, -16776961, 0.4f);
                } else {
                    Renderer.setColor(area, s, v.pos);
                }
                GLAdapter.gl.vertexAttribPointer(s.aPos, 2, 5122, false, 0, ml.vertexOffset);
                GLAdapter.gl.drawElements(4, ml.numIndices, 5123, ml.indiceOffset);
                l = (RenderBucket)l.next;
            }
            return l;
        }

        static void setColor(AreaStyle a, Shader s, MapPosition pos) {
            float fade = a.getFade(pos.scale);
            float blend = a.getBlend(pos.scale);
            if (fade < 1.0f) {
                GLState.blend(true);
                GLUtils.setColor(s.uColor, a.color, fade);
            } else if (blend > 0.0f) {
                if (blend == 1.0f) {
                    GLUtils.setColor(s.uColor, a.blendColor, 1.0f);
                } else {
                    GLUtils.setColorBlend(s.uColor, a.color, a.blendColor, blend);
                }
            } else {
                GLState.blend((a.color & 0xFF000000) != -16777216);
                GLUtils.setColor(s.uColor, a.color, 1.0f);
            }
        }

        static class Shader
        extends GLShader {
            int uMVP;
            int uColor;
            int uHeight;
            int aPos;

            Shader(String shaderFile) {
                if (!this.create(shaderFile)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uColor = this.getUniform("u_color");
                this.uHeight = this.getUniform("u_height");
                this.aPos = this.getAttrib("a_pos");
            }
        }
    }
}

