/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderBuckets
extends MapTile.TileData {
    static final Logger log = LoggerFactory.getLogger(RenderBuckets.class);
    public static final int[] VERTEX_SHORT_CNT = new int[]{4, 6, 2, 2, 4, 2, 6, 6, 2};
    private static final int SHORT_BYTES = 2;
    private RenderBucket buckets;
    public BufferObject vbo;
    public BufferObject ibo;
    public int[] offset = new int[]{0, 0};
    private RenderBucket mCurBucket;
    private static short[] fillCoords;

    public LineBucket addLineBucket(int level, LineStyle style) {
        LineBucket l = (LineBucket)this.getBucket(level, 0);
        if (l == null) {
            return null;
        }
        l.scale = 1.0f;
        l.line = style;
        return l;
    }

    public PolygonBucket addPolygonBucket(int level, AreaStyle style) {
        PolygonBucket l = (PolygonBucket)this.getBucket(level, 2);
        if (l == null) {
            return null;
        }
        l.area = style;
        return l;
    }

    public MeshBucket addMeshBucket(int level, AreaStyle style) {
        MeshBucket l = (MeshBucket)this.getBucket(level, 3);
        if (l == null) {
            return null;
        }
        l.area = style;
        return l;
    }

    public HairLineBucket addHairLineBucket(int level, LineStyle style) {
        HairLineBucket ll = this.getHairLineBucket(level);
        if (ll == null) {
            return null;
        }
        ll.line = style;
        return ll;
    }

    public CircleBucket addCircleBucket(int level, CircleStyle style) {
        CircleBucket l = (CircleBucket)this.getBucket(level, 8);
        if (l == null) {
            return null;
        }
        l.circle = style;
        return l;
    }

    public LineBucket getLineBucket(int level) {
        return (LineBucket)this.getBucket(level, 0);
    }

    public MeshBucket getMeshBucket(int level) {
        return (MeshBucket)this.getBucket(level, 3);
    }

    public PolygonBucket getPolygonBucket(int level) {
        return (PolygonBucket)this.getBucket(level, 2);
    }

    public LineTexBucket getLineTexBucket(int level) {
        return (LineTexBucket)this.getBucket(level, 1);
    }

    public HairLineBucket getHairLineBucket(int level) {
        return (HairLineBucket)this.getBucket(level, 5);
    }

    public CircleBucket getCircleBucket(int level) {
        return (CircleBucket)this.getBucket(level, 8);
    }

    public void set(RenderBucket buckets) {
        RenderBucket l = this.buckets;
        while (l != null) {
            l.clear();
            l = (RenderBucket)l.next;
        }
        this.buckets = buckets;
    }

    public RenderBucket get() {
        return this.buckets;
    }

    private RenderBucket getBucket(int level, int type) {
        RenderBucket bucket = null;
        if (this.mCurBucket != null && this.mCurBucket.level == level) {
            bucket = this.mCurBucket;
            if (bucket.type != type) {
                log.error("BUG wrong bucket {} {} on level {}", new Object[]{(int)bucket.type, type, level});
                throw new IllegalArgumentException();
            }
            return bucket;
        }
        RenderBucket b = this.buckets;
        if (b == null || b.level > level) {
            b = null;
        } else {
            if (this.mCurBucket != null && level > this.mCurBucket.level) {
                b = this.mCurBucket;
            }
            while (true) {
                if (b.level == level) {
                    bucket = b;
                    break;
                }
                if (b.next == null || ((RenderBucket)b.next).level > level) break;
                b = (RenderBucket)b.next;
            }
        }
        if (bucket == null) {
            if (type == 0) {
                bucket = new LineBucket(level);
            } else if (type == 2) {
                bucket = new PolygonBucket(level);
            } else if (type == 1) {
                bucket = new LineTexBucket(level);
            } else if (type == 3) {
                bucket = new MeshBucket(level);
            } else if (type == 5) {
                bucket = new HairLineBucket(level);
            } else if (type == 8) {
                bucket = new CircleBucket(level);
            }
            if (bucket == null) {
                throw new IllegalArgumentException();
            }
            if (b == null) {
                bucket.next = this.buckets;
                this.buckets = bucket;
            } else {
                bucket.next = b.next;
                b.next = bucket;
            }
        }
        if (bucket.type != type) {
            log.error("BUG wrong bucket {} {} on level {}", new Object[]{(int)bucket.type, type, level});
            throw new IllegalArgumentException();
        }
        this.mCurBucket = bucket;
        return bucket;
    }

    private int countVboSize() {
        int vboShorts = 0;
        RenderBucket l = this.buckets;
        while (l != null) {
            vboShorts += l.numVertices * VERTEX_SHORT_CNT[l.type];
            l = (RenderBucket)l.next;
        }
        return vboShorts;
    }

    private int countIboSize() {
        int numIndices = 0;
        RenderBucket l = this.buckets;
        while (l != null) {
            numIndices += l.numIndices;
            l = (RenderBucket)l.next;
        }
        return numIndices;
    }

    public void setFrom(RenderBuckets buckets) {
        if (buckets == this) {
            throw new IllegalArgumentException("Cannot set from oneself!");
        }
        this.set(buckets.buckets);
        this.mCurBucket = null;
        buckets.buckets = null;
        buckets.mCurBucket = null;
    }

    public void clear() {
        this.set(null);
        this.mCurBucket = null;
        this.vbo = BufferObject.release(this.vbo);
        this.ibo = BufferObject.release(this.ibo);
    }

    public void clearBuckets() {
        RenderBucket l = this.buckets;
        while (l != null) {
            l.clear();
            l = (RenderBucket)l.next;
        }
        this.mCurBucket = null;
    }

    @Override
    protected void dispose() {
        this.clear();
    }

    public void prepare() {
        RenderBucket l = this.buckets;
        while (l != null) {
            l.prepare();
            l = (RenderBucket)l.next;
        }
    }

    public void bind() {
        if (this.vbo != null) {
            this.vbo.bind();
        }
        if (this.ibo != null) {
            this.ibo.bind();
        }
    }

    public boolean compile(boolean addFill) {
        int vboSize = this.countVboSize();
        if (vboSize <= 0) {
            this.vbo = BufferObject.release(this.vbo);
            this.ibo = BufferObject.release(this.ibo);
            return false;
        }
        if (addFill) {
            vboSize += 8;
        }
        ShortBuffer vboData = MapRenderer.getShortBuffer(vboSize);
        if (addFill) {
            vboData.put(fillCoords, 0, 8);
        }
        ShortBuffer iboData = null;
        int iboSize = this.countIboSize();
        if (iboSize > 0) {
            iboData = MapRenderer.getShortBuffer(iboSize);
        }
        int pos = addFill ? 4 : 0;
        RenderBucket l = this.buckets;
        while (l != null) {
            if (l.type == 2) {
                l.compile(vboData, iboData);
                l.vertexOffset = pos;
                pos += l.numVertices;
            }
            l = (RenderBucket)l.next;
        }
        this.offset[0] = vboData.position() * 2;
        pos = 0;
        l = this.buckets;
        while (l != null) {
            if (l.type == 0) {
                l.compile(vboData, iboData);
                l.vertexOffset = pos;
                pos += l.numVertices;
            }
            l = (RenderBucket)l.next;
        }
        l = this.buckets;
        while (l != null) {
            if (l.type != 0 && l.type != 2) {
                l.compile(vboData, iboData);
            }
            l = (RenderBucket)l.next;
        }
        if (vboSize != vboData.position()) {
            log.debug("wrong vertex buffer size:  new size: " + vboSize + " buffer pos: " + vboData.position() + " buffer limit: " + vboData.limit() + " buffer fill: " + vboData.remaining());
            return false;
        }
        if (iboSize > 0 && iboSize != iboData.position()) {
            log.debug("wrong indice buffer size:  new size: " + iboSize + " buffer pos: " + iboData.position() + " buffer limit: " + iboData.limit() + " buffer fill: " + iboData.remaining());
            return false;
        }
        if (this.vbo == null) {
            this.vbo = BufferObject.get(34962, vboSize);
        }
        this.vbo.loadBufferData(vboData.flip(), vboSize * 2);
        if (iboSize > 0) {
            if (this.ibo == null) {
                this.ibo = BufferObject.get(34963, iboSize);
            }
            this.ibo.loadBufferData(iboData.flip(), iboSize * 2);
        }
        return true;
    }

    public static void initRenderer() {
        LineBucket.Renderer.init();
        LineTexBucket.Renderer.init();
        PolygonBucket.Renderer.init();
        TextureBucket.Renderer.init();
        BitmapBucket.Renderer.init();
        MeshBucket.Renderer.init();
        HairLineBucket.Renderer.init();
        CircleBucket.Renderer.init();
    }

    static {
        short s = (short)((float)Tile.SIZE * MapRenderer.COORD_SCALE);
        fillCoords = new short[]{0, s, s, s, 0, 0, s, 0};
    }
}

