/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextBucket
extends TextureBucket {
    static final Logger log = LoggerFactory.getLogger(TextBucket.class);
    protected static final int LBIT_MASK = -2;
    protected static int mFontPadX = 1;
    public TextItem labels;
    protected final Canvas mCanvas = CanvasAdapter.newCanvas();

    public TextItem getLabels() {
        return this.labels;
    }

    public void setLabels(TextItem labels) {
        this.labels = labels;
    }

    public TextBucket() {
        super((byte)6);
        this.fixed = true;
        this.level = -1;
    }

    public void addText(TextItem item) {
        TextItem it = this.labels;
        while (it != null) {
            if (item.text == it.text) {
                while (it.next != null && item.text == ((TextItem)it.next).text && item.label != it.label && !item.label.equals(it.label)) {
                    it = (TextItem)it.next;
                }
                if (item.label != it.label && item.label.equals(it.label)) {
                    item.label = it.label;
                }
                item.next = it.next;
                it.next = item;
                return;
            }
            it = (TextItem)it.next;
        }
        item.next = this.labels;
        this.labels = item;
    }

    @Override
    public void prepare() {
        TextureItem t;
        int numIndices = 0;
        int offsetIndices = 0;
        int advanceY = 0;
        float x = 0.0f;
        float y = 0.0f;
        this.textures = t = pool.get();
        this.mCanvas.setBitmap(t.bitmap);
        TextItem it = this.labels;
        while (it != null) {
            float width = it.width + (float)(2 * mFontPadX);
            float height = (float)((int)it.text.fontHeight) + 0.5f;
            if (height > 256.0f) {
                height = 256.0f;
            }
            if (height > (float)advanceY) {
                advanceY = (int)height;
            }
            if (x + width > 1024.0f) {
                x = 0.0f;
                y += (float)advanceY;
                advanceY = (int)(height + 0.5f);
                if (y + height > 256.0f) {
                    t.offset = offsetIndices;
                    t.indices = numIndices - offsetIndices;
                    offsetIndices = numIndices;
                    t.next = pool.get();
                    t = (TextureItem)t.next;
                    this.mCanvas.setBitmap(t.bitmap);
                    x = 0.0f;
                    y = 0.0f;
                    advanceY = (int)height;
                }
            }
            float yy = y + height - it.text.fontDescent;
            this.mCanvas.drawText(it.label, x, yy, it.text.paint, it.text.stroke);
            if (width > 1024.0f) {
                width = 1024.0f;
            }
            while (it != null) {
                this.addItem(it, width, height, x, y);
                numIndices += 6;
                this.numVertices += 4;
                if (it.next == null || ((TextItem)it.next).text != it.text || ((TextItem)it.next).label != it.label) {
                    it = (TextItem)it.next;
                    break;
                }
                it = (TextItem)it.next;
            }
            x += width;
        }
        t.offset = offsetIndices;
        t.indices = numIndices - offsetIndices;
    }

    protected void addItem(TextItem it, float width, float height, float x, float y) {
        short y3;
        short y4;
        short y1;
        short y2;
        short x2;
        short x4;
        short x1;
        short x3;
        short u1 = (short)(MapRenderer.COORD_SCALE * x);
        short v1 = (short)(MapRenderer.COORD_SCALE * y);
        short u2 = (short)(MapRenderer.COORD_SCALE * (x + width));
        short v2 = (short)(MapRenderer.COORD_SCALE * (y + height));
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (it.text.caption) {
            x1 = x3 = (short)(MapRenderer.COORD_SCALE * -hw);
            x2 = x4 = (short)(MapRenderer.COORD_SCALE * hw);
            y1 = y2 = (short)(MapRenderer.COORD_SCALE * (it.text.dy + hh));
            y3 = y4 = (short)(MapRenderer.COORD_SCALE * (it.text.dy - hh));
        } else {
            float vx = it.x1 - it.x2;
            float vy = it.y1 - it.y2;
            float a = (float)Math.sqrt(vx * vx + vy * vy);
            float ux = -(vy /= a) * hh;
            float uy = (vx /= a) * hh;
            float ux2 = -vy * hh;
            float uy2 = vx * hh;
            x1 = (short)(MapRenderer.COORD_SCALE * ((vx *= hw) - ux));
            y1 = (short)(MapRenderer.COORD_SCALE * ((vy *= hw) - uy));
            x2 = (short)(MapRenderer.COORD_SCALE * (-vx - ux));
            y2 = (short)(MapRenderer.COORD_SCALE * (-vy - uy));
            x4 = (short)(MapRenderer.COORD_SCALE * (-vx + ux2));
            y4 = (short)(MapRenderer.COORD_SCALE * (-vy + uy2));
            x3 = (short)(MapRenderer.COORD_SCALE * (vx + ux2));
            y3 = (short)(MapRenderer.COORD_SCALE * (vy + uy2));
        }
        int tmp = (int)(MapRenderer.COORD_SCALE * it.x) & 0xFFFFFFFE;
        short tx = (short)(tmp | (it.text.caption ? 1 : 0));
        short ty = (short)(MapRenderer.COORD_SCALE * it.y);
        this.vertexItems.add(tx, ty, x1, y1, u1, v2);
        this.vertexItems.add(tx, ty, x3, y3, u1, v1);
        this.vertexItems.add(tx, ty, x2, y2, u2, v2);
        this.vertexItems.add(tx, ty, x4, y4, u2, v1);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearLabels();
    }

    public void clearLabels() {
        this.labels = TextItem.pool.releaseAll(this.labels);
    }
}

