/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.scalebar;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.oscim.map.Map;
import org.oscim.scalebar.DistanceUnitAdapter;
import org.oscim.scalebar.ImperialUnitAdapter;
import org.oscim.scalebar.MapScaleBar;

public class DefaultMapScaleBar
extends MapScaleBar {
    private static final int BITMAP_HEIGHT = 40;
    private static final int BITMAP_WIDTH = 120;
    private static final int DEFAULT_HORIZONTAL_MARGIN = 5;
    private static final int DEFAULT_VERTICAL_MARGIN = 0;
    private static final int SCALE_BAR_MARGIN = 10;
    private static final float STROKE_EXTERNAL = 4.0f;
    private static final float STROKE_INTERNAL = 2.0f;
    private static final int TEXT_MARGIN = 1;
    private final float scale;
    private ScaleBarMode scaleBarMode;
    private DistanceUnitAdapter secondaryDistanceUnitAdapter;
    private final Paint paintScaleBar;
    private final Paint paintScaleBarStroke;
    private final Paint paintScaleText;
    private final Paint paintScaleTextStroke;

    public DefaultMapScaleBar(Map map) {
        this(map, CanvasAdapter.getScale());
    }

    public DefaultMapScaleBar(Map map, float scale) {
        super(map, (int)(120.0f * scale), (int)(40.0f * scale));
        this.setMarginHorizontal((int)(5.0f * scale));
        this.setMarginVertical((int)(0.0f * scale));
        this.scale = scale;
        this.scaleBarMode = ScaleBarMode.BOTH;
        this.secondaryDistanceUnitAdapter = ImperialUnitAdapter.INSTANCE;
        this.paintScaleBar = this.createScaleBarPaint(-16777216, 2.0f, Paint.Style.FILL);
        this.paintScaleBarStroke = this.createScaleBarPaint(-1, 4.0f, Paint.Style.STROKE);
        this.paintScaleText = this.createTextPaint(-16777216, 0.0f, Paint.Style.FILL);
        this.paintScaleTextStroke = this.createTextPaint(-1, 2.0f, Paint.Style.STROKE);
    }

    public DistanceUnitAdapter getSecondaryDistanceUnitAdapter() {
        return this.secondaryDistanceUnitAdapter;
    }

    public void setSecondaryDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter == null) {
            throw new IllegalArgumentException("adapter must not be null");
        }
        this.secondaryDistanceUnitAdapter = distanceUnitAdapter;
        this.redrawNeeded = true;
    }

    public ScaleBarMode getScaleBarMode() {
        return this.scaleBarMode;
    }

    public void setScaleBarMode(ScaleBarMode scaleBarMode) {
        this.scaleBarMode = scaleBarMode;
        this.redrawNeeded = true;
    }

    private Paint createScaleBarPaint(int color, float strokeWidth, Paint.Style style) {
        Paint paint = CanvasAdapter.newPaint();
        paint.setColor(color);
        paint.setStrokeWidth(strokeWidth * this.scale);
        paint.setStyle(style);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        return paint;
    }

    private Paint createTextPaint(int color, float strokeWidth, Paint.Style style) {
        Paint paint = CanvasAdapter.newPaint();
        paint.setColor(color);
        paint.setStrokeWidth(strokeWidth * this.scale);
        paint.setStyle(style);
        paint.setTypeface(Paint.FontFamily.DEFAULT, Paint.FontStyle.BOLD);
        paint.setTextSize(12.0f * this.scale);
        return paint;
    }

    @Override
    protected void redraw(Canvas canvas) {
        canvas.fillColor(0);
        MapScaleBar.ScaleBarLengthAndValue lengthAndValue = this.calculateScaleBarLengthAndValue();
        MapScaleBar.ScaleBarLengthAndValue lengthAndValue2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.calculateScaleBarLengthAndValue(this.secondaryDistanceUnitAdapter) : new MapScaleBar.ScaleBarLengthAndValue(0, 0);
        this.drawScaleBar(canvas, lengthAndValue.scaleBarLength, lengthAndValue2.scaleBarLength, this.paintScaleBarStroke, this.scale);
        this.drawScaleBar(canvas, lengthAndValue.scaleBarLength, lengthAndValue2.scaleBarLength, this.paintScaleBar, this.scale);
        String scaleText1 = this.distanceUnitAdapter.getScaleText(lengthAndValue.scaleBarValue);
        String scaleText2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.secondaryDistanceUnitAdapter.getScaleText(lengthAndValue2.scaleBarValue) : "";
        this.drawScaleText(canvas, scaleText1, scaleText2, this.paintScaleTextStroke, this.scale);
        this.drawScaleText(canvas, scaleText1, scaleText2, this.paintScaleText, this.scale);
    }

    private void drawScaleBar(Canvas canvas, int scaleBarLength1, int scaleBarLength2, Paint paint, float scale) {
        int maxScaleBarLength = Math.max(scaleBarLength1, scaleBarLength2);
        switch (this.scaleBarPosition) {
            case BOTTOM_CENTER: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case BOTTOM_LEFT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case BOTTOM_RIGHT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_CENTER: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_LEFT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_RIGHT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
            }
        }
    }

    private void drawScaleText(Canvas canvas, String scaleText1, String scaleText2, Paint paint, float scale) {
        switch (this.scaleBarPosition) {
            case BOTTOM_CENTER: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(((float)canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(scaleText1)) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case BOTTOM_LEFT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case BOTTOM_RIGHT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText2)), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_CENTER: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(((float)canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(scaleText1)) * 0.5f), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_LEFT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_RIGHT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - this.paintScaleTextStroke.getTextWidth(scaleText2)), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
            }
        }
    }

    public static enum ScaleBarMode {
        BOTH,
        SINGLE;

    }
}

