/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeStyleLayer;
import org.oscim.theme.XmlRenderThemeStyleMenu;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMapsforgeThemeBuilder
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(XmlMapsforgeThemeBuilder.class);
    private static final int RENDER_THEME_VERSION = 6;
    private static final String ELEMENT_NAME_RENDER_THEME = "rendertheme";
    private static final String ELEMENT_NAME_STYLE_MENU = "stylemenu";
    private static final String ELEMENT_NAME_MATCH = "rule";
    private static final String UNEXPECTED_ELEMENT = "unexpected element: ";
    private static final String LINE_STYLE = "L";
    private static final String OUTLINE_STYLE = "O";
    private static final String AREA_STYLE = "A";
    private static final int DEFAULT_PRIORITY = 0x3FFFFFFF;
    private final ArrayList<RuleBuilder> mRulesList = new ArrayList();
    private final Stack<Element> mElementStack = new Stack();
    private final Stack<RuleBuilder> mRuleStack = new Stack();
    private final HashMap<String, RenderStyle> mStyles = new HashMap(10);
    private final HashMap<String, TextStyle.TextBuilder<?>> mTextStyles = new HashMap(10);
    private final AreaStyle.AreaBuilder<?> mAreaBuilder = AreaStyle.builder();
    private final CircleStyle.CircleBuilder<?> mCircleBuilder = CircleStyle.builder();
    private final ExtrusionStyle.ExtrusionBuilder<?> mExtrusionBuilder = ExtrusionStyle.builder();
    private final LineStyle.LineBuilder<?> mLineBuilder = LineStyle.builder();
    private final SymbolStyle.SymbolBuilder<?> mSymbolBuilder = SymbolStyle.builder();
    private final TextStyle.TextBuilder<?> mTextBuilder = TextStyle.builder();
    private RuleBuilder mCurrentRule;
    private TextureAtlas mTextureAtlas;
    int mLevels = 0;
    int mMapBackground = -1;
    private float mStrokeScale = 1.0f;
    float mTextScale = 1.0f;
    final ThemeFile mTheme;
    private final ThemeCallback mThemeCallback;
    RenderTheme mRenderTheme;
    private final float mScale;
    private final float mScale2;
    private Set<String> mCategories;
    private XmlRenderThemeStyleLayer mCurrentLayer;
    private XmlRenderThemeStyleMenu mRenderThemeStyleMenu;

    public static IRenderTheme read(ThemeFile theme) throws IRenderTheme.ThemeException {
        return XmlMapsforgeThemeBuilder.read(theme, null);
    }

    public static IRenderTheme read(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        XmlMapsforgeThemeBuilder renderThemeHandler = new XmlMapsforgeThemeBuilder(theme, themeCallback);
        try {
            new XMLReaderAdapter().parse(renderThemeHandler, theme.getRenderThemeAsStream());
        }
        catch (Exception e) {
            throw new IRenderTheme.ThemeException(e.getMessage());
        }
        return renderThemeHandler.mRenderTheme;
    }

    private static void logUnknownAttribute(String element, String name, String value, int attributeIndex) {
        log.debug("unknown attribute in element {} () : {} = {}", new Object[]{element, attributeIndex, name, value});
    }

    public XmlMapsforgeThemeBuilder(ThemeFile theme) {
        this(theme, null);
    }

    public XmlMapsforgeThemeBuilder(ThemeFile theme, ThemeCallback themeCallback) {
        this.mTheme = theme;
        this.mThemeCallback = themeCallback;
        this.mScale = CanvasAdapter.getScale();
        this.mScale2 = CanvasAdapter.getScale() * 0.5f;
    }

    @Override
    public void endDocument() {
        this.mRulesList.add(this.buildingRule());
        Rule[] rules = new Rule[this.mRulesList.size()];
        int n = rules.length;
        for (int i = 0; i < n; ++i) {
            rules[i] = this.mRulesList.get(i).onComplete(new int[1]);
        }
        this.mRenderTheme = this.createTheme(rules);
        this.mRulesList.clear();
        this.mStyles.clear();
        this.mRuleStack.clear();
        this.mElementStack.clear();
        this.mTextureAtlas = null;
    }

    RenderTheme createTheme(Rule[] rules) {
        return new RenderTheme(this.mMapBackground, this.mTextScale, rules, this.mLevels, true);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.mElementStack.pop();
        if (ELEMENT_NAME_MATCH.equals(localName)) {
            this.mRuleStack.pop();
            if (this.mRuleStack.empty()) {
                if (this.isVisible(this.mCurrentRule)) {
                    this.mRulesList.add(this.mCurrentRule);
                }
            } else {
                this.mCurrentRule = this.mRuleStack.peek();
            }
        } else if (ELEMENT_NAME_STYLE_MENU.equals(localName) && null != this.mTheme.getMenuCallback()) {
            this.mCategories = this.mTheme.getMenuCallback().getCategories(this.mRenderThemeStyleMenu);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        log.debug(exception.getMessage());
    }

    @Override
    public void warning(SAXParseException exception) {
        log.debug(exception.getMessage());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws IRenderTheme.ThemeException {
        block35: {
            try {
                if (ELEMENT_NAME_RENDER_THEME.equals(localName)) {
                    this.checkState(localName, Element.RENDER_THEME);
                    this.createRenderTheme(localName, attributes);
                    break block35;
                }
                if (ELEMENT_NAME_MATCH.equals(localName)) {
                    this.checkState(localName, Element.RULE);
                    RuleBuilder rule = this.createRule(localName, attributes);
                    if (!this.mRuleStack.empty() && this.isVisible(rule)) {
                        this.mCurrentRule.addSubRule(rule);
                    }
                    this.mCurrentRule = rule;
                    this.mRuleStack.push(this.mCurrentRule);
                    break block35;
                }
                if ("style-text".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleTextElement(localName, attributes, true, false);
                    break block35;
                }
                if ("style-area".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleAreaElement(localName, attributes, true);
                    break block35;
                }
                if ("style-line".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleLineElement(localName, attributes, true, false);
                    break block35;
                }
                if ("outline-layer".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    LineStyle line = this.createLine(null, localName, attributes, this.mLevels++, true, false);
                    this.mStyles.put(OUTLINE_STYLE + line.style, line);
                    break block35;
                }
                if ("area".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleAreaElement(localName, attributes, false);
                    break block35;
                }
                if ("caption".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(localName, attributes, false, true);
                    break block35;
                }
                if ("circle".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    CircleStyle circle = this.createCircle(localName, attributes, this.mLevels++);
                    if (this.isVisible(circle)) {
                        this.mCurrentRule.addStyle(circle);
                    }
                    break block35;
                }
                if ("line".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(localName, attributes, false, false);
                    break block35;
                }
                if ("text".equals(localName) || "pathText".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(localName, attributes, false, false);
                    break block35;
                }
                if ("symbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    SymbolStyle symbol = this.createSymbol(localName, attributes);
                    if (symbol != null && this.isVisible(symbol)) {
                        this.mCurrentRule.addStyle(symbol);
                    }
                    break block35;
                }
                if ("outline".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    LineStyle outline = this.createOutline(attributes.getValue("use"), attributes);
                    if (outline != null && this.isVisible(outline)) {
                        this.mCurrentRule.addStyle(outline);
                    }
                    break block35;
                }
                if ("extrusion".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    ExtrusionStyle extrusion = this.createExtrusion(localName, attributes, this.mLevels++);
                    if (this.isVisible(extrusion)) {
                        this.mCurrentRule.addStyle(extrusion);
                    }
                    break block35;
                }
                if ("lineSymbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(localName, attributes, false, true);
                    break block35;
                }
                if ("atlas".equals(localName)) {
                    this.checkState(localName, Element.ATLAS);
                    this.createAtlas(localName, attributes);
                    break block35;
                }
                if ("rect".equals(localName)) {
                    this.checkState(localName, Element.ATLAS);
                    this.createTextureRegion(localName, attributes);
                    break block35;
                }
                if ("cat".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addCategory(this.getStringAttribute(attributes, "id"));
                    break block35;
                }
                if ("layer".equals(localName)) {
                    XmlRenderThemeStyleLayer parentEntry;
                    this.checkState(qName, Element.RENDERING_STYLE);
                    boolean enabled = false;
                    if (this.getStringAttribute(attributes, "enabled") != null) {
                        enabled = Boolean.valueOf(this.getStringAttribute(attributes, "enabled"));
                    }
                    boolean visible = Boolean.valueOf(this.getStringAttribute(attributes, "visible"));
                    this.mCurrentLayer = this.mRenderThemeStyleMenu.createLayer(this.getStringAttribute(attributes, "id"), visible, enabled);
                    String parent = this.getStringAttribute(attributes, "parent");
                    if (null != parent && null != (parentEntry = this.mRenderThemeStyleMenu.getLayer(parent))) {
                        for (String cat : parentEntry.getCategories()) {
                            this.mCurrentLayer.addCategory(cat);
                        }
                        for (XmlRenderThemeStyleLayer overlay : parentEntry.getOverlays()) {
                            this.mCurrentLayer.addOverlay(overlay);
                        }
                    }
                    break block35;
                }
                if ("name".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addTranslation(this.getStringAttribute(attributes, "lang"), this.getStringAttribute(attributes, "value"));
                    break block35;
                }
                if ("overlay".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    XmlRenderThemeStyleLayer overlay = this.mRenderThemeStyleMenu.getLayer(this.getStringAttribute(attributes, "id"));
                    if (overlay != null) {
                        this.mCurrentLayer.addOverlay(overlay);
                    }
                    break block35;
                }
                if (ELEMENT_NAME_STYLE_MENU.equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mRenderThemeStyleMenu = new XmlRenderThemeStyleMenu(this.getStringAttribute(attributes, "id"), this.getStringAttribute(attributes, "defaultlang"), this.getStringAttribute(attributes, "defaultvalue"));
                    break block35;
                }
                log.error("unknown element: {}", (Object)localName);
                throw new SAXException("unknown element: " + localName);
            }
            catch (SAXException e) {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
        }
    }

    private RuleBuilder createRule(String localName, Attributes attributes) {
        String cat = null;
        int element = 7;
        int closed = 3;
        String keys = null;
        String values = null;
        byte zoomMin = 0;
        byte zoomMax = 127;
        int selector = 0;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String val;
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("e".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("WAY".equals(val)) {
                    element = 6;
                    continue;
                }
                if (!"NODE".equals(val)) continue;
                element = 1;
                continue;
            }
            if ("k".equals(name)) {
                if ("*".equals(value)) continue;
                keys = value;
                continue;
            }
            if ("v".equals(name)) {
                if ("*".equals(value)) continue;
                values = value;
                continue;
            }
            if ("cat".equals(name)) {
                cat = value;
                continue;
            }
            if ("closed".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("YES".equals(val)) {
                    closed = 2;
                    continue;
                }
                if (!"NO".equals(val)) continue;
                closed = 1;
                continue;
            }
            if ("zoom-min".equals(name)) {
                zoomMin = Byte.parseByte(value);
                continue;
            }
            if ("zoom-max".equals(name)) {
                zoomMax = Byte.parseByte(value);
                continue;
            }
            if ("select".equals(name)) {
                if ("first".equals(value)) {
                    selector |= 1;
                }
                if (!"when-matched".equals(value)) continue;
                selector |= 2;
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(localName, name, value, i);
        }
        if (closed == 2) {
            element = 4;
        } else if (closed == 1) {
            element = 2;
        }
        XmlMapsforgeThemeBuilder.validateNonNegative("zoom-min", zoomMin);
        XmlMapsforgeThemeBuilder.validateNonNegative("zoom-max", zoomMax);
        if (zoomMin > zoomMax) {
            throw new IRenderTheme.ThemeException("zoom-min must be less or equal zoom-max: " + zoomMin);
        }
        RuleBuilder b = RuleBuilder.create(keys, values);
        b.cat(cat);
        b.zoom(zoomMin, zoomMax);
        b.element(element);
        b.select(selector);
        return b;
    }

    private TextureRegion getAtlasRegion(String src) {
        if (this.mTextureAtlas == null) {
            return null;
        }
        TextureRegion texture = this.mTextureAtlas.getTextureRegion(src);
        if (texture == null) {
            log.debug("missing texture atlas item '" + src + "'");
        }
        return texture;
    }

    private void handleLineElement(String localName, Attributes attributes, boolean isStyle, boolean hasSymbol) throws SAXException {
        String use = attributes.getValue("use");
        LineStyle style = null;
        if (use != null && (style = (LineStyle)this.mStyles.get(LINE_STYLE + use)) == null) {
            log.debug("missing line style 'use': " + use);
            return;
        }
        LineStyle line = this.createLine(style, localName, attributes, this.mLevels++, false, hasSymbol);
        if (isStyle) {
            this.mStyles.put(LINE_STYLE + line.style, line);
        } else if (this.isVisible(line)) {
            LineStyle outline;
            this.mCurrentRule.addStyle(line);
            String outlineValue = attributes.getValue("outline");
            if (outlineValue != null && (outline = this.createOutline(outlineValue, attributes)) != null) {
                this.mCurrentRule.addStyle(outline);
            }
        }
    }

    private LineStyle createLine(LineStyle line, String elementName, Attributes attributes, int level, boolean isOutline, boolean hasSymbol) {
        Bitmap bitmap;
        int width;
        Object b = this.mLineBuilder.set(line);
        ((LineStyle.LineBuilder)b).isOutline(isOutline);
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                ((LineStyle.LineBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("use".equals(name) || "outline".equals(name)) continue;
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(value);
                continue;
            }
            if ("width".equals(name) || "stroke-width".equals(name)) {
                ((LineStyle.LineBuilder)b).strokeWidth = Float.parseFloat(value) * this.mScale2 * this.mStrokeScale;
                if (line == null) {
                    if (isOutline) continue;
                    XmlMapsforgeThemeBuilder.validateNonNegative("width", ((LineStyle.LineBuilder)b).strokeWidth);
                    continue;
                }
                ((LineStyle.LineBuilder)b).strokeWidth += line.width;
                if (!(((LineStyle.LineBuilder)b).strokeWidth <= 0.0f)) continue;
                ((LineStyle.LineBuilder)b).strokeWidth = 1.0f;
                continue;
            }
            if ("cap".equals(name) || "stroke-linecap".equals(name)) {
                ((LineStyle.LineBuilder)b).cap = Paint.Cap.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("fix".equals(name)) {
                ((LineStyle.LineBuilder)b).fixed = Boolean.parseBoolean(value);
                continue;
            }
            if ("stipple".equals(name)) {
                ((LineStyle.LineBuilder)b).stipple = Math.round((float)Integer.parseInt(value) * this.mScale2 * this.mStrokeScale);
                continue;
            }
            if ("stipple-stroke".equals(name)) {
                ((LineStyle.LineBuilder)b).stippleColor(value);
                continue;
            }
            if ("stipple-width".equals(name)) {
                ((LineStyle.LineBuilder)b).stippleWidth = Float.parseFloat(value);
                continue;
            }
            if ("fade".equals(name)) {
                ((LineStyle.LineBuilder)b).fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("min".equals(name)) continue;
            if ("blur".equals(name)) {
                ((LineStyle.LineBuilder)b).blur = Float.parseFloat(value);
                continue;
            }
            if ("style".equals(name)) continue;
            if ("dasharray".equals(name) || "stroke-dasharray".equals(name)) {
                ((LineStyle.LineBuilder)b).dashArray = XmlMapsforgeThemeBuilder.parseFloatArray(value);
                for (int j = 0; j < ((LineStyle.LineBuilder)b).dashArray.length; ++j) {
                    ((LineStyle.LineBuilder)b).dashArray[j] = ((LineStyle.LineBuilder)b).dashArray[j] * this.mScale * this.mStrokeScale;
                }
                continue;
            }
            if ("symbol-width".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("repeat-start".equals(name)) {
                ((LineStyle.LineBuilder)b).repeatStart = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("repeat-gap".equals(name)) {
                ((LineStyle.LineBuilder)b).repeatGap = Float.parseFloat(value) * this.mScale;
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        if (((LineStyle.LineBuilder)b).dashArray != null) {
            if (((LineStyle.LineBuilder)b).dashArray.length % 2 != 0) {
                float[] newDashArray = new float[((LineStyle.LineBuilder)b).dashArray.length * 2];
                System.arraycopy(((LineStyle.LineBuilder)b).dashArray, 0, newDashArray, 0, ((LineStyle.LineBuilder)b).dashArray.length);
                System.arraycopy(((LineStyle.LineBuilder)b).dashArray, 0, newDashArray, ((LineStyle.LineBuilder)b).dashArray.length, ((LineStyle.LineBuilder)b).dashArray.length);
                ((LineStyle.LineBuilder)b).dashArray = newDashArray;
            }
            width = 0;
            int height = (int)((LineStyle.LineBuilder)b).strokeWidth;
            if (height < 1) {
                height = 1;
            }
            for (Object f : (String)((LineStyle.LineBuilder)b).dashArray) {
                if (f < 1.0f) {
                    f = 1.0f;
                }
                width = (int)((float)width + f);
            }
            bitmap = CanvasAdapter.newBitmap(width, height, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(bitmap);
            int x = 0;
            boolean transparent = false;
            for (float f : ((LineStyle.LineBuilder)b).dashArray) {
                if (f < 1.0f) {
                    f = 1.0f;
                }
                canvas.fillRectangle(x, 0.0f, f, height, transparent ? 0 : -1);
                x = (int)((float)x + f);
                transparent = !transparent;
            }
            ((LineStyle.LineBuilder)b).texture = new TextureItem(Utils.potBitmap(bitmap));
            ((LineStyle.LineBuilder)b).texture.mipmap = true;
            ((LineStyle.LineBuilder)b).randomOffset = false;
            ((LineStyle.LineBuilder)b).stipple = width;
            ((LineStyle.LineBuilder)b).stippleWidth = 1.0f;
            ((LineStyle.LineBuilder)b).stippleColor = ((LineStyle.LineBuilder)b).fillColor;
        } else {
            ((LineStyle.LineBuilder)b).texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), src, ((LineStyle.LineBuilder)b).symbolWidth, ((LineStyle.LineBuilder)b).symbolHeight, ((LineStyle.LineBuilder)b).symbolPercent);
            if (hasSymbol) {
                width = (int)((float)((LineStyle.LineBuilder)b).texture.width + ((LineStyle.LineBuilder)b).repeatGap);
                int height = ((LineStyle.LineBuilder)b).texture.height;
                bitmap = CanvasAdapter.newBitmap(width, height, 0);
                Canvas canvas = CanvasAdapter.newCanvas();
                canvas.setBitmap(bitmap);
                canvas.drawBitmap(((LineStyle.LineBuilder)b).texture.bitmap, ((LineStyle.LineBuilder)b).repeatStart, 0.0f);
                ((LineStyle.LineBuilder)b).texture = new TextureItem(Utils.potBitmap(bitmap));
                ((LineStyle.LineBuilder)b).texture.mipmap = true;
                ((LineStyle.LineBuilder)b).fixed = true;
                ((LineStyle.LineBuilder)b).randomOffset = false;
                ((LineStyle.LineBuilder)b).stipple = width;
                ((LineStyle.LineBuilder)b).stippleWidth = 1.0f;
                ((LineStyle.LineBuilder)b).strokeWidth = (float)height * 0.5f;
                ((LineStyle.LineBuilder)b).stippleColor = -1;
            }
        }
        return ((LineStyle.LineBuilder)b).build();
    }

    private void handleAreaElement(String localName, Attributes attributes, boolean isStyle) throws SAXException {
        String use = attributes.getValue("use");
        AreaStyle style = null;
        if (use != null && (style = (AreaStyle)this.mStyles.get(AREA_STYLE + use)) == null) {
            log.debug("missing area style 'use': " + use);
            return;
        }
        AreaStyle area = this.createArea(style, localName, attributes, this.mLevels++);
        if (isStyle) {
            this.mStyles.put(AREA_STYLE + area.style, area);
        } else if (this.isVisible(area)) {
            this.mCurrentRule.addStyle(area);
        }
    }

    private AreaStyle createArea(AreaStyle area, String elementName, Attributes attributes, int level) {
        Object b = this.mAreaBuilder.set(area);
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                ((AreaStyle.AreaBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("use".equals(name)) continue;
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("fill".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(value);
                continue;
            }
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeColor(value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                float strokeWidth = Float.parseFloat(value);
                XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", strokeWidth);
                ((AreaStyle.AreaBuilder)b).strokeWidth = strokeWidth * this.mScale * this.mStrokeScale;
                continue;
            }
            if ("fade".equals(name)) {
                ((AreaStyle.AreaBuilder)b).fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("blend".equals(name)) {
                ((AreaStyle.AreaBuilder)b).blendScale = Integer.parseInt(value);
                continue;
            }
            if ("blend-fill".equals(name)) {
                ((AreaStyle.AreaBuilder)b).blendColor(value);
                continue;
            }
            if ("mesh".equals(name)) {
                ((AreaStyle.AreaBuilder)b).mesh(Boolean.parseBoolean(value));
                continue;
            }
            if ("symbol-width".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        ((AreaStyle.AreaBuilder)b).texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), src, ((AreaStyle.AreaBuilder)b).symbolWidth, ((AreaStyle.AreaBuilder)b).symbolHeight, ((AreaStyle.AreaBuilder)b).symbolPercent);
        return ((AreaStyle.AreaBuilder)b).build();
    }

    private LineStyle createOutline(String style, Attributes attributes) {
        LineStyle line;
        if (style != null && (line = (LineStyle)this.mStyles.get(OUTLINE_STYLE + style)) != null && line.outline) {
            String cat = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (!"cat".equals(name)) continue;
                cat = value;
                break;
            }
            return (LineStyle)line.setCat(cat);
        }
        log.debug("BUG not an outline style: " + style);
        return null;
    }

    private void createAtlas(String elementName, Attributes attributes) throws IOException {
        String img = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("img".equals(name)) {
                img = value;
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("img", img, elementName);
        Bitmap bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), img);
        if (bitmap != null) {
            this.mTextureAtlas = new TextureAtlas(bitmap);
        }
    }

    private void createTextureRegion(String elementName, Attributes attributes) {
        if (this.mTextureAtlas == null) {
            return;
        }
        String regionName = null;
        TextureAtlas.Rect r = null;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                regionName = value;
                continue;
            }
            if ("pos".equals(name)) {
                String[] pos = value.split(" ");
                if (pos.length != 4) continue;
                r = new TextureAtlas.Rect(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("id", regionName, elementName);
        XmlMapsforgeThemeBuilder.validateExists("pos", r, elementName);
        this.mTextureAtlas.addTextureRegion(regionName.intern(), r);
    }

    private void checkElement(String elementName, Element element) throws SAXException {
        switch (element) {
            case RENDER_THEME: {
                if (!this.mElementStack.empty()) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RULE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case STYLE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RENDERING_INSTRUCTION: {
                if (this.mElementStack.peek() != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case ATLAS: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.ATLAS) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RENDERING_STYLE: {
                return;
            }
        }
        throw new SAXException("unknown enum value: " + (Object)((Object)element));
    }

    private void checkState(String elementName, Element element) throws SAXException {
        this.checkElement(elementName, element);
        this.mElementStack.push(element);
    }

    private void createRenderTheme(String elementName, Attributes attributes) {
        Integer version = null;
        int mapBackground = -1;
        float baseStrokeWidth = 1.0f;
        float baseTextScale = 1.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("schemaLocation".equals(name)) continue;
            if ("version".equals(name)) {
                version = Integer.parseInt(value);
                continue;
            }
            if ("map-background".equals(name)) {
                mapBackground = Color.parseColor(value);
                if (this.mThemeCallback == null) continue;
                mapBackground = this.mThemeCallback.getColor(mapBackground);
                continue;
            }
            if ("base-stroke-width".equals(name)) {
                baseStrokeWidth = Float.parseFloat(value);
                continue;
            }
            if ("base-text-scale".equals(name) || "base-text-size".equals(name)) {
                baseTextScale = Float.parseFloat(value);
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("version", version, elementName);
        if (version > 6) {
            throw new IRenderTheme.ThemeException("invalid render theme version:" + version);
        }
        XmlMapsforgeThemeBuilder.validateNonNegative("base-stroke-width", baseStrokeWidth);
        XmlMapsforgeThemeBuilder.validateNonNegative("base-text-scale", baseTextScale);
        this.mMapBackground = mapBackground;
        this.mStrokeScale = baseStrokeWidth;
        this.mTextScale = baseTextScale;
    }

    private void handleTextElement(String localName, Attributes attributes, boolean isStyle, boolean isCaption) throws SAXException {
        String style = attributes.getValue("use");
        TextStyle.TextBuilder<?> pt = null;
        if (style != null && (pt = this.mTextStyles.get(style)) == null) {
            log.debug("missing text style: " + style);
            return;
        }
        TextStyle.TextBuilder<?> b = this.createText(localName, attributes, isCaption, pt);
        if (isStyle) {
            log.debug("put style {}", (Object)b.style);
            this.mTextStyles.put(b.style, (TextStyle.TextBuilder<?>)TextStyle.builder().from(b));
        } else {
            TextStyle text = b.buildInternal();
            if (this.isVisible(text)) {
                this.mCurrentRule.addStyle(text);
            }
        }
    }

    private TextStyle.TextBuilder<?> createText(String elementName, Attributes attributes, boolean caption, TextStyle.TextBuilder<?> style) {
        Object b;
        if (style == null) {
            b = this.mTextBuilder.reset();
            ((TextStyle.TextBuilder)b).caption = caption;
        } else {
            b = this.mTextBuilder.from(style);
        }
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String symbol = null;
        ((TextStyle.TextBuilder)b).priority = 0x3FFFFFFF;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                ((TextStyle.TextBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("k".equals(name)) {
                ((TextStyle.TextBuilder)b).textKey = value.intern();
                continue;
            }
            if ("font-family".equals(name)) {
                ((TextStyle.TextBuilder)b).fontFamily = Paint.FontFamily.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("style".equals(name) || "font-style".equals(name)) {
                ((TextStyle.TextBuilder)b).fontStyle = Paint.FontStyle.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("size".equals(name) || "font-size".equals(name)) {
                ((TextStyle.TextBuilder)b).fontSize = Float.parseFloat(value);
                continue;
            }
            if ("fill".equals(name)) {
                ((TextStyle.TextBuilder)b).fillColor = Color.parseColor(value);
                continue;
            }
            if ("stroke".equals(name)) {
                ((TextStyle.TextBuilder)b).strokeColor = Color.parseColor(value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                ((TextStyle.TextBuilder)b).strokeWidth = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("caption".equals(name)) {
                ((TextStyle.TextBuilder)b).caption = Boolean.parseBoolean(value);
                continue;
            }
            if ("priority".equals(name)) {
                ((TextStyle.TextBuilder)b).priority = Integer.parseInt(value);
                ((TextStyle.TextBuilder)b).priority = FastMath.clamp(0x3FFFFFFF - ((TextStyle.TextBuilder)b).priority, 0, Integer.MAX_VALUE);
                continue;
            }
            if ("area-size".equals(name)) {
                ((TextStyle.TextBuilder)b).areaSize = Float.parseFloat(value);
                continue;
            }
            if ("dy".equals(name)) {
                ((TextStyle.TextBuilder)b).dy = -Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("symbol".equals(name)) {
                symbol = value;
                continue;
            }
            if ("use".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("position".equals(name)) {
                if (((TextStyle.TextBuilder)b).dy != 0.0f) continue;
                value = "above".equals(value) ? "20" : "-20";
                ((TextStyle.TextBuilder)b).dy = -Float.parseFloat(value) * this.mScale;
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("k", ((TextStyle.TextBuilder)b).textKey, elementName);
        XmlMapsforgeThemeBuilder.validateNonNegative("size", ((TextStyle.TextBuilder)b).fontSize);
        XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", ((TextStyle.TextBuilder)b).strokeWidth);
        if (symbol != null && symbol.length() > 0) {
            String lowValue = symbol.toLowerCase(Locale.ENGLISH);
            if (lowValue.endsWith(".png") || lowValue.endsWith(".svg")) {
                try {
                    ((TextStyle.TextBuilder)b).bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), symbol, ((TextStyle.TextBuilder)b).symbolWidth, ((TextStyle.TextBuilder)b).symbolHeight, ((TextStyle.TextBuilder)b).symbolPercent);
                }
                catch (Exception e) {
                    log.error("{}: {}", (Object)symbol, (Object)e.getMessage());
                }
            } else {
                ((TextStyle.TextBuilder)b).texture = this.getAtlasRegion(symbol);
            }
        }
        return b;
    }

    private CircleStyle createCircle(String elementName, Attributes attributes, int level) {
        Object b = this.mCircleBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("r".equals(name) || "radius".equals(name)) {
                ((CircleStyle.CircleBuilder)b).radius(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("scale-radius".equals(name)) {
                ((CircleStyle.CircleBuilder)b).scaleRadius(Boolean.parseBoolean(value));
                continue;
            }
            if ("fill".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(Color.parseColor(value));
                continue;
            }
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeColor(Color.parseColor(value));
                continue;
            }
            if ("stroke-width".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeWidth(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("radius", Float.valueOf(((CircleStyle.CircleBuilder)b).radius), elementName);
        XmlMapsforgeThemeBuilder.validateNonNegative("radius", ((CircleStyle.CircleBuilder)b).radius);
        XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", ((CircleStyle.CircleBuilder)b).strokeWidth);
        return ((CircleStyle.CircleBuilder)b).build();
    }

    private SymbolStyle createSymbol(String elementName, Attributes attributes) {
        Object b = this.mSymbolBuilder.reset();
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("symbol-width".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("src", src, elementName);
        String lowSrc = src.toLowerCase(Locale.ENGLISH);
        if (lowSrc.endsWith(".png") || lowSrc.endsWith(".svg")) {
            try {
                Bitmap bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), src, ((SymbolStyle.SymbolBuilder)b).symbolWidth, ((SymbolStyle.SymbolBuilder)b).symbolHeight, ((SymbolStyle.SymbolBuilder)b).symbolPercent);
                if (bitmap != null) {
                    return this.buildSymbol((SymbolStyle.SymbolBuilder<?>)b, src, bitmap);
                }
            }
            catch (Exception e) {
                log.error("{}: {}", (Object)src, (Object)e.getMessage());
            }
            return null;
        }
        return ((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)b).texture(this.getAtlasRegion(src))).build();
    }

    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b, String src, Bitmap bitmap) {
        return ((SymbolStyle.SymbolBuilder)b.bitmap(bitmap)).build();
    }

    private ExtrusionStyle createExtrusion(String elementName, Attributes attributes, int level) {
        Object b = this.mExtrusionBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("side-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorSide(Color.parseColor(value));
                continue;
            }
            if ("top-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorTop(Color.parseColor(value));
                continue;
            }
            if ("line-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorLine(Color.parseColor(value));
                continue;
            }
            if ("default-height".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).defaultHeight(Integer.parseInt(value));
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        return ((ExtrusionStyle.ExtrusionBuilder)b).build();
    }

    private String getStringAttribute(Attributes attributes, String name) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private boolean isVisible(RenderStyle renderStyle) {
        return this.mCategories == null || renderStyle.cat == null || this.mCategories.contains(renderStyle.cat);
    }

    private boolean isVisible(RuleBuilder rule) {
        return this.mCategories == null || rule.cat == null || this.mCategories.contains(rule.cat);
    }

    private static float[] parseFloatArray(String dashString) {
        String[] dashEntries = dashString.split(",");
        float[] dashIntervals = new float[dashEntries.length];
        for (int i = 0; i < dashEntries.length; ++i) {
            dashIntervals[i] = Float.parseFloat(dashEntries[i]);
        }
        return dashIntervals;
    }

    private static void validateNonNegative(String name, float value) {
        if (value < 0.0f) {
            throw new IRenderTheme.ThemeException(name + " must not be negative: " + value);
        }
    }

    private static void validateExists(String name, Object obj, String elementName) {
        if (obj == null) {
            throw new IRenderTheme.ThemeException("missing attribute " + name + " for element: " + elementName);
        }
    }

    private RuleBuilder buildingRule() {
        Object b = this.mExtrusionBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(this.mLevels++);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorLine(-2500394);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorSide(-353571863);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorTop(-352716554);
        RuleBuilder rule = new RuleBuilder(RuleBuilder.RuleType.POSITIVE, new String[]{"building"}, new String[0]);
        rule.element(6).zoom((byte)17, (byte)127).style(new RenderStyle.StyleBuilder[]{b});
        return rule;
    }

    private static enum Element {
        RENDER_THEME,
        RENDERING_INSTRUCTION,
        RULE,
        STYLE,
        ATLAS,
        RENDERING_STYLE;

    }
}

