/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.ArrayList;
import java.util.List;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapReadResult;
import org.oscim.tiling.source.mapfile.MultiMapDataSink;
import org.oscim.tiling.source.mapfile.MultiMapFileTileSource;

public class MultiMapDatabase
implements ITileDataSource {
    private final List<MapDatabase> mapDatabases = new ArrayList<MapDatabase>();
    private final MultiMapFileTileSource tileSource;

    public MultiMapDatabase(MultiMapFileTileSource tileSource) {
        this.tileSource = tileSource;
    }

    public boolean add(MapDatabase mapDatabase) {
        if (this.mapDatabases.contains(mapDatabase)) {
            throw new IllegalArgumentException("Duplicate map database");
        }
        return this.mapDatabases.add(mapDatabase);
    }

    @Override
    public void query(MapTile tile, ITileDataSink mapDataSink) {
        MultiMapDataSink multiMapDataSink = new MultiMapDataSink(mapDataSink);
        for (MapDatabase mapDatabase : this.mapDatabases) {
            if (!mapDatabase.supportsTile(tile)) continue;
            mapDatabase.query(tile, multiMapDataSink);
        }
        mapDataSink.completed(multiMapDataSink.getResult());
    }

    @Override
    public void dispose() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.dispose();
        }
    }

    @Override
    public void cancel() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.cancel();
        }
    }

    public MapReadResult readLabels(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readLabels(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public MapReadResult readLabels(Tile upperLeft, Tile lowerRight) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readLabels(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readMapData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile upperLeft, Tile lowerRight) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readMapData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readPoiData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile upperLeft, Tile lowerRight) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readPoiData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, false);
        }
        return mapReadResult;
    }

    public boolean supportsTile(Tile tile) {
        for (MapDatabase mdb : this.mapDatabases) {
            if (!mdb.supportsTile(tile)) continue;
            return true;
        }
        return false;
    }
}

