/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.Arrays;
import java.util.List;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tag;

public class Way {
    public final GeoPoint labelPosition;
    public GeometryBuffer.GeometryType geometryType = GeometryBuffer.GeometryType.NONE;
    public final GeoPoint[][] geoPoints;
    public final byte layer;
    public final List<Tag> tags;

    public Way(byte layer, List<Tag> tags, GeoPoint[][] geoPoints, GeoPoint labelPosition) {
        this.layer = layer;
        this.tags = tags;
        this.geoPoints = geoPoints;
        this.labelPosition = labelPosition;
    }

    public Way(byte layer, List<Tag> tags, GeoPoint[][] geoPoints, GeoPoint labelPosition, GeometryBuffer.GeometryType geometryType) {
        this(layer, tags, geoPoints, labelPosition);
        this.geometryType = geometryType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Way)) {
            return false;
        }
        Way other = (Way)obj;
        if (this.layer != other.layer) {
            return false;
        }
        if (!this.tags.equals(other.tags)) {
            return false;
        }
        if (this.labelPosition == null && other.labelPosition != null) {
            return false;
        }
        if (this.labelPosition != null && !this.labelPosition.equals(other.labelPosition)) {
            return false;
        }
        if (this.geoPoints.length != other.geoPoints.length) {
            return false;
        }
        for (int i = 0; i < this.geoPoints.length; ++i) {
            if (this.geoPoints[i].length != other.geoPoints[i].length) {
                return false;
            }
            for (int j = 0; j < this.geoPoints[i].length; ++j) {
                if (this.geoPoints[i][j].equals(other.geoPoints[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.layer;
        result = 31 * result + this.tags.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.geoPoints);
        if (this.labelPosition != null) {
            result = 31 * result + this.labelPosition.hashCode();
        }
        return result;
    }
}

