/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.backend.canvas.Color;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Vec3;

public class ColorUtil {
    private static final Vec3 TMP_VEC = new Vec3();

    public static synchronized int desaturate(int color) {
        Vec3 hsl = TMP_VEC;
        ColorUtil.rgbToHsl(Color.r(color), Color.g(color), Color.b(color), hsl);
        return ColorUtil.hslToRgb(hsl.x, 0.0, hsl.z);
    }

    public static synchronized int saturate(int color, double saturation) {
        Vec3 hsl = TMP_VEC;
        ColorUtil.rgbToHsv(Color.r(color), Color.g(color), Color.b(color), hsl);
        return ColorUtil.hsvToRgb(hsl.x, saturation, hsl.z);
    }

    public static synchronized int setHue(int color, double hue) {
        Vec3 hsl = TMP_VEC;
        ColorUtil.rgbToHsv(Color.r(color), Color.g(color), Color.b(color), hsl);
        return ColorUtil.hsvToRgb(hue, hsl.y, hsl.z, null);
    }

    public static synchronized int shiftHue(int color, double hue) {
        Vec3 hsv = TMP_VEC;
        ColorUtil.rgbToHsv(Color.r(color), Color.g(color), Color.b(color), hsv);
        hsv.x += hue;
        hsv.x -= Math.floor(hsv.x);
        return ColorUtil.hsvToRgb(FastMath.clamp(hsv.x, 0.0, 1.0), hsv.y, hsv.z, null);
    }

    public static synchronized int saturate(int color, double saturation, boolean relative) {
        Vec3 hsl = TMP_VEC;
        ColorUtil.rgbToHsv(Color.r(color), Color.g(color), Color.b(color), hsl);
        return ColorUtil.hsvToRgb(hsl.x, FastMath.clamp(saturation * hsl.y, 0.0, 1.0), hsl.z);
    }

    public static synchronized int modHsv(int color, double hue, double saturation, double value, boolean relative) {
        Vec3 hsl = TMP_VEC;
        ColorUtil.rgbToHsv(Color.r(color), Color.g(color), Color.b(color), hsl);
        return ColorUtil.hsvToRgb(FastMath.clamp(hue * hsl.x, 0.0, 1.0), FastMath.clamp(saturation * hsl.y, 0.0, 1.0), FastMath.clamp(value * hsl.z, 0.0, 1.0));
    }

    public static Vec3 rgbToHsl(double r, double g, double b, Vec3 out) {
        double max = Math.max(r /= 255.0, Math.max(g /= 255.0, b /= 255.0));
        double min = Math.min(r, Math.min(g, b));
        double h = 0.0;
        double s = 0.0;
        double l = (max + min) / 2.0;
        if (max != min) {
            double d = max - min;
            double d2 = s = l > 0.5 ? d / (2.0 - max - min) : d / (max + min);
            h = max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0);
            h /= 6.0;
        }
        out.set(h, s, l);
        return out;
    }

    public static Vec3 rgbToHsl(double r, double g, double b) {
        return ColorUtil.rgbToHsl(r, g, b, new Vec3());
    }

    public static int hslToRgb(double h, double s, double l, Vec3 out) {
        double r;
        double g;
        double b;
        if (s == 0.0) {
            g = b = l;
            r = b;
        } else {
            double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
            double p = 2.0 * l - q;
            r = ColorUtil.hue2rgb(p, q, h + 0.0);
            g = ColorUtil.hue2rgb(p, q, h);
            b = ColorUtil.hue2rgb(p, q, h - 0.0);
        }
        if (out != null) {
            out.set(r, g, b);
        }
        return Color.get(r, g, b);
    }

    static double hue2rgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.0) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.0) {
            return q;
        }
        if (t < 0.0) {
            return p + (q - p) * (0.0 - t) * 6.0;
        }
        return p;
    }

    public static Vec3 rgbToHsv(double r, double g, double b, Vec3 out) {
        double s;
        double max = Math.max(r /= 255.0, Math.max(g /= 255.0, b /= 255.0));
        double min = Math.min(r, Math.min(g, b));
        double h = 0.0;
        double v = max;
        double d = max - min;
        double d2 = s = max == 0.0 ? 0.0 : d / max;
        if (max != min) {
            if (max == r) {
                h = (g - b) / d + (double)(g < b ? 6 : 0);
            } else if (max == g) {
                h = (b - r) / d + 2.0;
            } else if (max == b) {
                h = (r - g) / d + 4.0;
            }
            h /= 6.0;
        }
        out.set(h, s, v);
        return out;
    }

    public static Vec3 rgbToHsv(double r, double g, double b) {
        return ColorUtil.rgbToHsv(r, g, b, new Vec3());
    }

    public static int hsvToRgb(double h, double s, double v, Vec3 out) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int i = (int)Math.floor(h * 6.0);
        double f = h * 6.0 - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        if (out != null) {
            out.set(r, g, b);
        }
        return Color.get(r, g, b);
    }

    public static int hsvToRgb(double h, double s, double v) {
        return ColorUtil.hsvToRgb(h, s, v, null);
    }

    public static int hslToRgb(double h, double s, double l) {
        return ColorUtil.hslToRgb(h, s, l, null);
    }
}

