/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.oscim.utils.geom.LineClipper;

public class TileClipper {
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private final LineClipper mLineClipper;
    private final GeometryBuffer mGeomOut = new GeometryBuffer(10, 1);

    public TileClipper(float xmin, float ymin, float xmax, float ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.mLineClipper = new LineClipper(xmin, ymin, xmax, ymax);
    }

    public void setRect(float xmin, float ymin, float xmax, float ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.mLineClipper.setRect(xmin, ymin, xmax, ymax);
    }

    public boolean clip(GeometryBuffer geom) {
        if (geom.isPoly()) {
            GeometryBuffer out = this.mGeomOut;
            out.clear();
            this.clipEdge(geom, out, 1);
            geom.clear();
            this.clipEdge(out, geom, 8);
            out.clear();
            this.clipEdge(geom, out, 2);
            geom.clear();
            this.clipEdge(out, geom, 4);
            if (geom.indexCurrentPos == 0 && geom.index[0] < 6) {
                return false;
            }
        } else if (geom.isLine()) {
            GeometryBuffer out = this.mGeomOut;
            out.clear();
            int numLines = this.mLineClipper.clipLine(geom, out);
            int[] idx = geom.ensureIndexSize(numLines + 1, false);
            System.arraycopy(out.index, 0, idx, 0, numLines);
            geom.index[numLines] = -1;
            float[] pts = geom.ensurePointSize(out.pointNextPos >> 1, false);
            System.arraycopy(out.points, 0, pts, 0, out.pointNextPos);
            geom.indexCurrentPos = out.indexCurrentPos;
            geom.pointNextPos = out.pointNextPos;
            if (geom.indexCurrentPos == 0 && geom.index[0] < 4) {
                return false;
            }
        }
        return true;
    }

    private boolean clipEdge(GeometryBuffer in, GeometryBuffer out, int edge) {
        int len;
        out.startPolygon();
        boolean outer = true;
        int pointPos = 0;
        int n = in.index.length;
        for (int indexPos = 0; indexPos < n && (len = in.index[indexPos]) >= 0; ++indexPos) {
            if (len == 0) {
                out.startPolygon();
                outer = true;
                continue;
            }
            if (len < 6) {
                pointPos += len;
                continue;
            }
            if (!outer) {
                out.startHole();
            }
            switch (edge) {
                case 1: {
                    this.clipRingLeft(indexPos, pointPos, in, out);
                    break;
                }
                case 2: {
                    this.clipRingRight(indexPos, pointPos, in, out);
                    break;
                }
                case 8: {
                    this.clipRingTop(indexPos, pointPos, in, out);
                    break;
                }
                case 4: {
                    this.clipRingBottom(indexPos, pointPos, in, out);
                }
            }
            pointPos += len;
            outer = false;
        }
        return true;
    }

    private void clipRingLeft(int indexPos, int pointPos, GeometryBuffer in, GeometryBuffer out) {
        int end = in.index[indexPos] + pointPos;
        float px = in.points[end - 2];
        float py = in.points[end - 1];
        int i = pointPos;
        while (i < end) {
            float cx = in.points[i++];
            float cy = in.points[i++];
            if (cx > this.xmin) {
                if (px > this.xmin) {
                    out.addPoint(cx, cy);
                } else {
                    out.addPoint(this.xmin, py + (cy - py) * (this.xmin - px) / (cx - px));
                    out.addPoint(cx, cy);
                }
            } else if (px > this.xmin) {
                out.addPoint(this.xmin, py + (cy - py) * (this.xmin - px) / (cx - px));
            }
            px = cx;
            py = cy;
        }
    }

    private void clipRingRight(int indexPos, int pointPos, GeometryBuffer in, GeometryBuffer out) {
        int len = in.index[indexPos] + pointPos;
        float px = in.points[len - 2];
        float py = in.points[len - 1];
        int i = pointPos;
        while (i < len) {
            float cx = in.points[i++];
            float cy = in.points[i++];
            if (cx < this.xmax) {
                if (px < this.xmax) {
                    out.addPoint(cx, cy);
                } else {
                    out.addPoint(this.xmax, py + (cy - py) * (this.xmax - px) / (cx - px));
                    out.addPoint(cx, cy);
                }
            } else if (px < this.xmax) {
                out.addPoint(this.xmax, py + (cy - py) * (this.xmax - px) / (cx - px));
            }
            px = cx;
            py = cy;
        }
    }

    private void clipRingTop(int indexPos, int pointPos, GeometryBuffer in, GeometryBuffer out) {
        int len = in.index[indexPos] + pointPos;
        float px = in.points[len - 2];
        float py = in.points[len - 1];
        int i = pointPos;
        while (i < len) {
            float cx = in.points[i++];
            int n = i++;
            float cy = in.points[n];
            if (cy < this.ymax) {
                if (py < this.ymax) {
                    out.addPoint(cx, cy);
                } else {
                    out.addPoint(px + (cx - px) * (this.ymax - py) / (cy - py), this.ymax);
                    out.addPoint(cx, cy);
                }
            } else if (py < this.ymax) {
                out.addPoint(px + (cx - px) * (this.ymax - py) / (cy - py), this.ymax);
            }
            px = cx;
            py = cy;
        }
    }

    private void clipRingBottom(int indexPos, int pointPos, GeometryBuffer in, GeometryBuffer out) {
        int len = in.index[indexPos] + pointPos;
        float px = in.points[len - 2];
        float py = in.points[len - 1];
        int i = pointPos;
        while (i < len) {
            float cx = in.points[i++];
            int n = i++;
            float cy = in.points[n];
            if (cy > this.ymin) {
                if (py > this.ymin) {
                    out.addPoint(cx, cy);
                } else {
                    out.addPoint(px + (cx - px) * (this.ymin - py) / (cy - py), this.ymin);
                    out.addPoint(cx, cy);
                }
            } else if (py > this.ymin) {
                out.addPoint(px + (cx - px) * (this.ymin - py) / (cy - py), this.ymin);
            }
            px = cx;
            py = cy;
        }
    }
}

