/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.data;

import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.marid.db.data.DataRecordKey;

public final class DataRecord<T extends Serializable>
implements Serializable {
    private final long tag;
    private final long timestamp;
    private final T value;

    public DataRecord(long tag, long timestamp, @NotNull T value) {
        this.tag = tag;
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTag() {
        return this.tag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public DataRecordKey getKey() {
        return new DataRecordKey(this.tag, this.timestamp);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.tag, this.timestamp, this.value});
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataRecord) {
            DataRecord that = (DataRecord)obj;
            return Arrays.deepEquals(new Object[]{this.tag, this.timestamp, this.value}, new Object[]{that.tag, that.timestamp, that.value});
        }
        return false;
    }

    public String toString() {
        Object val = Arrays.deepToString(new Object[]{this.value});
        if (((String)val).length() > 100) {
            val = ((String)val).substring(0, 100) + "...]";
        }
        return String.format("(%d, %tc, %s)", this.tag, this.timestamp, val);
    }
}

