/*
 * Decompiled with CFR 0.152.
 */
package org.marid.proto;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.Map;

public interface Proto {
    public String getName();

    public String getId();

    public Proto getParent();

    public Map<String, ? extends Proto> getItems();

    public static LinkedList<String> path(Proto proto) {
        LinkedList<String> path = new LinkedList<String>();
        for (Proto p = proto; p != null; p = p.getParent()) {
            path.addFirst(p.getId());
        }
        return path;
    }

    public static String label(Proto proto) {
        return proto.getName() + ": " + Proto.path(proto);
    }

    public static IOException close(Map<String, ? extends Closeable> closeableMap) {
        IOException exception = new IOException();
        for (Map.Entry<String, ? extends Closeable> e : closeableMap.entrySet()) {
            String id = e.getKey();
            Closeable closeable = e.getValue();
            try {
                closeable.close();
            }
            catch (IOException x) {
                exception.addSuppressed(new UncheckedIOException(id, x));
            }
            catch (Exception x) {
                exception.addSuppressed(x);
            }
        }
        return exception;
    }
}

