/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.dao;

import java.util.Collections;
import java.util.function.Consumer;
import org.marid.db.dao.NumericWriter;
import org.marid.db.data.DataRecord;

public interface DaqConsumers {
    public static Consumer<Float> floatWriter(NumericWriter numericWriter, long tag) {
        return val -> {
            DataRecord<Double> record = new DataRecord<Double>(tag, System.currentTimeMillis(), val.doubleValue());
            numericWriter.merge(Collections.singletonList(record), true);
        };
    }

    public static Consumer<Double> doubleWriter(NumericWriter numericWriter, long tag) {
        return val -> {
            DataRecord<Double> record = new DataRecord<Double>(tag, System.currentTimeMillis(), (Double)val);
            numericWriter.merge(Collections.singletonList(record), true);
        };
    }

    public static Consumer<Integer> intWriter(NumericWriter numericWriter, long tag) {
        return val -> {
            DataRecord<Double> record = new DataRecord<Double>(tag, System.currentTimeMillis(), val.doubleValue());
            numericWriter.merge(Collections.singletonList(record), true);
        };
    }

    public static Consumer<Long> longWriter(NumericWriter numericWriter, long tag) {
        return val -> {
            DataRecord<Double> record = new DataRecord<Double>(tag, System.currentTimeMillis(), val.doubleValue());
            numericWriter.merge(Collections.singletonList(record), true);
        };
    }
}

