/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.data;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.marid.db.data.DataRecordKey;

public final class DataRecord<T extends Serializable> {
    private final long tag;
    private final Instant timestamp;
    private final T value;

    @ConstructorProperties(value={"tag", "timestamp", "value"})
    public DataRecord(long tag, Instant timestamp, @Nonnull T value) {
        this.tag = tag;
        this.timestamp = timestamp;
        this.value = value;
    }

    public long getTag() {
        return this.tag;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public T getValue() {
        return this.value;
    }

    public DataRecordKey getKey() {
        return new DataRecordKey(this.tag, this.timestamp);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.tag, this.timestamp, this.value});
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataRecord) {
            DataRecord that = (DataRecord)obj;
            return Arrays.deepEquals(new Object[]{this.tag, this.timestamp, this.value}, new Object[]{that.tag, that.timestamp, that.value});
        }
        return false;
    }

    public String toString() {
        String val = Arrays.deepToString(new Object[]{this.value});
        if (val.length() > 100) {
            val = val.substring(0, 100) + "...]";
        }
        return String.format("(%d, %s, %s)", this.tag, this.timestamp, val);
    }
}

